using System;

namespace konjugacija
{
    internal class Program
    {
        public struct Segment 
        {
            public int l, r;
            public double center;

            public Segment(int _l, int _r)
            {
                l = Math.Min(_l, _r);
                r = Math.Max(_l, _r);
                center = (l + r) / 2;
            }
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Segment[] segments = new Segment[n];
            for (int i = 0; i < n; i++)
            {
                string[] input = Console.ReadLine().Split();
                segments[i] = new Segment(int.Parse(input[0]), int.Parse(input[1]));
            }

            int counter = 0;

            for (int i = 0; i < n; i++)
            {
                for(int j = 0; j < n; j++)
                {
                    if (j == i)
                        continue;
                    if (segments[i].center >= segments[j].l && segments[i].center <= segments[j].r)
                        if (segments[j].center <= segments[i].r && segments[j].center >= segments[i].l)
                            counter++;
                }
            }
            counter /= 2;

            Console.WriteLine(counter);
        }
    }
}