#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;

const int N = 200000;

struct tri{
    ll l, r, c;
} a[N+5];

int seg[4*N+5];

void upd(int node, int l, int r, int x, int t){
    if(l == r){
        seg[node] = t;
        return;
    }
    int mid = (l+r)/2;
    if(x <= mid) upd(node*2, l, mid, x, t);
    else upd(node*2+1, mid+1, r, x, t);
    seg[node] = seg[node*2] + seg[node*2+1];
}

int query(int node, int l, int r, int i){
    if(l >= i) return 0;
    if(a[r].c < a[i].l) return 0;
    if(a[l].c >= a[i].l) return seg[node];
    int mid = (l+r)/2;
    return query(node*2, l, mid, i) + query(node*2+1, mid+1, r, i);
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

    int n;
    cin >> n;
    for(int i=1; i<=n; i++){
        cin >> a[i].l >> a[i].r;
        a[i].l *= 2;
        a[i].r *= 2;
        a[i].c = (a[i].l + a[i].r)/2;
    }
    sort(a+1, a+1+n, [](tri x, tri y){ return x.c < y.c; });
    ll res = 0;
    priority_queue <pair <int, int>, vector <pair <int, int>>, greater <pair <int, int>>> q;
    for(int i=1; i<=n; i++){
        while(!q.empty() && q.top().first < a[i].c){
            upd(1, 1, n, q.top().second, 0);
            q.pop();
        }
        res += query(1, 1, n, i);
        upd(1, 1, n, i, 1);
        q.push({a[i].r, i});
    }
    cout << res << "\n";
    return 0;
}