#include <bits/stdc++.h>

using namespace std;

vector< pair <int, int> > v;


typedef struct cvor
{
	int info;
	struct cvor *L, *D;
} Cvor;

Cvor* sledeci(int br)
{
	Cvor* t = new Cvor;
	t->info = br;
	t->L = t->D = NULL;
	return t;
}

Cvor* pravi(int l, int r)
{
    if(l > r) return NULL;

    int m = (l + r) / 2;
    Cvor *prvi = sledeci(v[m].first);
 
    prvi->L = pravi(l, m - 1);
 	prvi->D = pravi(m + 1, r);
 
    return prvi;
}

Cvor* brisi(Cvor* prvi, int x)
{
	if(prvi == NULL)
		return prvi;

	if(prvi->info > x)
	{
		prvi->L = brisi(prvi->L, x);
		return prvi;
	}
	else if(prvi->info < x)
	{
		prvi->D = brisi(prvi->D, x);
		return prvi;
	}

	if(prvi->L == NULL)
	{
		Cvor* t = prvi->D;
		delete prvi;
		return t;
	}
	else if(prvi->D == NULL)
	{
		Cvor* t = prvi->L;
		delete prvi;
		return t;
	}
	else
	{
		Cvor* P = prvi;

		Cvor* p = prvi->D;
		while(p->L != NULL) 
		{
			P = p;
			p = p->L;
		}

		if(P != prvi) P->L = p->D;
		else P->D = p->D;

		prvi->info = p->info;

		delete p;
		return prvi;
	}
}

int broj(Cvor *prvi, int l, int r)
{
    if(!prvi) return 0;
    if(prvi->info == r && prvi->info == l) return 1;

    if(prvi->info <= r && prvi->info >= l) return broj(prvi->L, l, r) + broj(prvi->D, l, r + 1) + 1;
    else if(prvi->info < l) return broj(prvi->D, l, r);
    else return broj(prvi->L, l, r);
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(NULL); cout.tie(NULL);
	
	int n; cin >> n;
	
	for(int i = 0; i < n; i++)
	{
		int l, r; cin >> l >> r;
		
		v.push_back({l + r, r - l});
	}
	
	sort(v.begin(), v.end());
	
	Cvor* prvi = pravi(0, n - 1);
	
	for(int i = 0; i < n; i++) swap(v[i].first, v[i].second);
	
	sort(v.begin(), v.end());

	long long s = 0;

	for(int i = 0; i < n - 1; i++)
	{	
		prvi = brisi(prvi, v[i].second);
		
		s += broj(prvi, v[i].second - v[i].first, v[i].second + v[i].first);
	}

	cout << s;
	
	return 0;
}