using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Takmicenje3._4
{
    struct Segment {
        public int poc;
        public int kraj;

        public Segment(int poc, int kraj) {
            this.poc = poc;
            this.kraj = kraj;
        }

        public double Centar() {
            return (poc + kraj) / 2.0;
        }

        public bool SadrziCentar(double centar) {
            return poc <= centar && centar <= kraj;
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            int n = Convert.ToInt32(Console.ReadLine());
            Segment[] segmenti = new Segment[n];
            for (int i = 0; i < n; i++) {
                string[] s = Console.ReadLine().Split();
                int x1 = Convert.ToInt32(s[0]);
                int x2 = Convert.ToInt32(s[1]);
                segmenti[i] = new Segment(x1,x2);
            }

            int rez = 0;
            double centarI, centarJ;
            for (int i = 0; i < n - 1; i++) {
                centarI = segmenti[i].Centar();
                for (int j = i+1; j < n; j++) {
                    centarJ = segmenti[j].Centar();

                    if (segmenti[i].SadrziCentar(centarJ) && segmenti[j].SadrziCentar(centarI))
                        rez++;
                }
            }

            Console.WriteLine(rez);
            Console.ReadKey();
        }
    }
}