#include <iostream>
#include <vector>
#include <algorithm>

struct segment
{
	int l;
	int r;
	bool done = false;
};

bool seg(const segment& p1, const segment& p2)
{
	return p1.r < p2.r;
}

int main()
{
	int n;
	int num = 0;

	std::cin >> n;

	std::vector<segment> segmenti(n);

	for(int i = 0; i < n; i++)
		std::cin >> segmenti[i].l >> segmenti[i].r;

	std::sort(segmenti.begin(), segmenti.end(), seg);

	for(int i = 0; i < n; i++)
	{
		float centar = static_cast<float>(segmenti[i].l + segmenti[i].r) / 2;

		for(int iter_l = i - 1; iter_l >= 0; iter_l--)
		{
			if(segmenti[iter_l].r >= centar && !segmenti[iter_l].done)
			{
				float seg_centar = static_cast<float>(segmenti[iter_l].l + segmenti[iter_l].r) / 2;
				if(seg_centar >= segmenti[i].l)
					num++;
			}
			else
				break;
		}

		for(int iter_r = i + 1; iter_r < n; iter_r++)
		{
			if(segmenti[iter_r].l <= centar && !segmenti[iter_r].done)
			{
				float seg_centar = static_cast<float>(segmenti[iter_r].l + segmenti[iter_r].r) / 2;
				if(seg_centar <= segmenti[i].r)
					num++;
			}
			else
				break;
		}

		segmenti[i].done = true;
	}

	std::cout << num;

	return 0;
}