#include <iostream>

struct Mladen {
    int size;
    int untillRed;
    int untillBlue;
    int untillGreen;
};
class Pouch {
private:  // Fields
    bool isMagical;
    int red;
    int blue;
    int green;
public:   // Constructors
    Pouch(const Mladen&);
public:   // Methods
    int GetRed() const;
    int GetBlue() const;
    int GetGreen() const;
    bool IsMagical() const;
};

void Untie();

int main() {
    Untie();
    Mladen mladen;
    std::cin >> mladen.size >> mladen.untillRed >> mladen.untillGreen >> mladen.untillBlue;
    Pouch pouch(mladen);
    if (pouch.IsMagical()) {
        std::cout << "nemoguce" << std::endl;
    }
    else {
        std::cout << "moguce" << std::endl;
        std::cout << pouch.GetRed() << ' ' << pouch.GetGreen() << ' ' << pouch.GetBlue() << std::endl;
    }
    return 0;
}


void Untie() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
    std::cerr.tie(nullptr);
}

// Pouch
Pouch::Pouch(const Mladen& info) {
    int maxGreen = info.size + 1 - info.untillGreen;
    int maxRed = info.size + 1 - info.untillRed;
    green = std::max(1, std::min(maxGreen, info.untillBlue - 2));
    red = std::max(1, std::min(maxRed, info.untillBlue - 1 - green));
    blue = info.size - (green + red);
    isMagical = (blue < 1) || (green + red < info.untillBlue - 1);
}

// Methods
int Pouch::GetRed() const {
    return red;
}
int Pouch::GetBlue() const {
    return blue;
}
int Pouch::GetGreen() const {
    return green;
}
bool Pouch::IsMagical() const {
    return isMagical;
}