#include <iostream>
#include <vector>
#include <map>
#include <queue>
using namespace std;

struct card
{
	int time;
	int node;
};

int main()
{
	int n, m; cin >> n >> m;
	vector<int> depth(n);
	vector<vector<int>> children(n);
	for (int node = 1; node < n; node++)
	{
		int ancestor; cin >> ancestor; ancestor--;
		children[ancestor].push_back(node);
	}
	queue<int> queue; queue.push(0);
	while(!queue.empty())
	{
		int node = queue.front(); queue.pop();
		for (int child : children[node])
		{
			queue.push(child);
			depth[child] = depth[node] + 1;
		}
	}

	vector<card> cards(m);
	for (int i = 0; i < m; i++)
	{
		int t, v; cin >> t >> v;
		cards[i].time = t;
		cards[i].node = v - 1;
	}
	sort(cards.begin(), cards.end(), [](card a, card b) { return a.time < b.time; });
	vector<vector<int>> card_snapshots;
	int snapshot = 0;
	card_snapshots.push_back(vector<int>());
	card_snapshots[0].push_back(cards[0].node);
	for (int i = 1; i < m; i++)
	{
		if (cards[i].time > cards[i - 1].time)
		{
			snapshot++;
			card_snapshots.push_back(vector<int>());
		}
		card_snapshots[snapshot].push_back(cards[i].node);
	}

	int throwaway_cnt = 0;
	map<int, int> card_depth;
	for (int snapshot = 0; snapshot < card_snapshots.size(); snapshot++)
	{
		for (int node : card_snapshots[snapshot])
		{
			card_depth[depth[node] + snapshot]++;
			if (card_depth[depth[node] + snapshot] % 2 == 0) throwaway_cnt += 2;
		}
	}

	cout << throwaway_cnt << endl;
}