using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Takmicenje
{
    internal class Program
    {
        struct VizitKarta
        {
            public int vreme;
            public int pozicija;

            public VizitKarta(int vreme, int pozicija)
            {
                this.vreme = vreme;
                this.pozicija = pozicija;
            }
        }

        static void Main(string[] args)
        {
            string[] ulaz1 = Console.ReadLine().Split(' ');
            int N = int.Parse(ulaz1[0]);
            int M = int.Parse(ulaz1[1]);
            int karte_kod_direktora = 0;
            int karte_kod_direktora_sada = 0;
            int najmanje_vreme = int.MaxValue;
            int najvece_vreme = int.MinValue;

            bool nije_prazno = true;

            int[] nadredjeni = new int[N - 1];
            int[] kolicina_karata_na_svakoj_poziciji = new int[N];
            int[] vremena = new int[M];

            string[] ulaz2 = Console.ReadLine().Split(' ');

            for (int i = 0; i < N - 1; i++)
            {
                nadredjeni[i] = int.Parse(ulaz2[i]);
            }

            Array.Sort(nadredjeni);

            VizitKarta[] vizitKarte = new VizitKarta[M];

            for (int i = 0; i < M; i++)
            {
                string[] ulaz = Console.ReadLine().Split(' ');
                int trenutno_vreme = int.Parse(ulaz[0]);
                vizitKarte[i] = new VizitKarta(trenutno_vreme, int.Parse(ulaz[1]));

                vremena[i] = trenutno_vreme;
            }

            Array.Sort (vremena);
            najmanje_vreme = vremena[0];
            najvece_vreme = vremena[vremena.Length - 1];

            int[] vremena2 = vremena.Distinct().ToArray();

            while (najmanje_vreme <= najvece_vreme || nije_prazno)
            {
                for (int i = 0;i < M; i++)
                {
                    if (vizitKarte[i].vreme < najmanje_vreme)
                    {
                        if (vizitKarte[i].pozicija == 1)
                        {
                            karte_kod_direktora_sada++;
                            vizitKarte[i].pozicija = -1;
                        }
                        if (vizitKarte[i].pozicija > 1)
                            vizitKarte[i].pozicija = nadredjeni[vizitKarte[i].pozicija - 2];
                    }
                }

                karte_kod_direktora += karte_kod_direktora_sada % 2;

                nije_prazno = false;

                for (int i = 0; i < M; i++)
                {
                    if (vizitKarte[i].pozicija != -1 && vizitKarte[i].vreme < najmanje_vreme)
                        nije_prazno = true;
                }

                

                karte_kod_direktora_sada = 0;
                najmanje_vreme++;

                if (najmanje_vreme < najvece_vreme && !nije_prazno)
                {
                    for (int i = 0; i < vremena2.Length; i++)
                    {
                        if (vremena2[i] > najmanje_vreme)
                        {
                            najmanje_vreme = vremena2[i];
                            break;
                        }
                    }
                }
            }

            Console.WriteLine(M - karte_kod_direktora);
            Console.ReadKey();
        }
    }
}