#include <iostream>
#include <cmath>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

struct Cord {
	int a, b;
	float c;

	bool operator < (const Cord& cord) const {
		return (c < cord.c);
	}

	bool operator > (const Cord& cord) const {
		return (c > cord.c);
	}
};

int main() {
	
	int n;
	cin >> n;

	vector<Cord> vect(n);

	for (int i = 0; i < n; i++) {
		cin >> vect[i].a >> vect[i].b;
		vect[i].c = float((vect[i].a+vect[i].b)/2.0);
	}

	sort(vect.begin(), vect.end());

	// for (auto x : vect) {
	// 	cout << x.c << " " << x.a << " " << x.b << " " << endl;
	// }
	// cout << "---------------- " << endl << endl;

	int ans = 0;

	for (int i = 0; i < n-1; i++) {
		Cord curr = vect[i];
		Cord low, high;
		low.c = curr.a;
		high.c = curr.b;

		auto first = lower_bound(vect.begin() + i + 1, vect.end(), low);
		auto last = upper_bound(vect.begin() + i + 1, vect.end(), high);

		for (auto it = first; it <= last; it++) {

			if ((*it).c >= curr.a and (*it).c <= curr.b) {
				ans++;
				//cout << curr.c << " " << (*it).c << endl;
			}
		}
	}

	cout << ans << endl;

	return 0;
}