#include <bits/stdc++.h>

#define pb push_back
#define ll long long
#define MAXN 150010

using namespace std;

class interval {

public:
    ll l, r, c, len;

    ll length() {
        return r - l + 1;
    }
    ll center() {
        return (l + r) / 2;
    }
};

bool cmp(interval a, interval b) {

    return a.length() < b.length();
}

vector<ll> v;
int cnt[3 * MAXN];

void compress(interval arr[], int n) {

    for(int i = 0; i < n; i++) {
        v.pb(arr[i].l);
        v.pb(arr[i].r);
        v.pb(arr[i].c);
    }
    sort(v.begin(), v.end());
    v.erase(unique(v.begin(), v.end()), v.end());

    for(int i = 0; i < n; i++) {
        arr[i].l = (lower_bound(v.begin(), v.end(), arr[i].l) - v.begin()) + 1;
        arr[i].r = (lower_bound(v.begin(), v.end(), arr[i].r) - v.begin()) + 1;
    }
}

int bit[3 * MAXN];

int get(int x) {

    int ans = 0;
    for(int i = x; i > 0; i -= i & -i)
        ans += bit[i];
    return ans;
}

void upd(int x, int diff, int n) {

    for(int i = x; i <= n + 1; i += i & -i)
        bit[i] += diff;
}

int get_val(int c, interval cor) {

    if(cor.len % 2)
        return get(c);
    return get(c) - cnt[c];
}

void upd_range(int l, int r, int n) {

    upd(l, 1, n);
    upd(r + 1, -1, n);
    cnt[r]++;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;

    interval arr[n];
    for(int i = 0; i < n; i++) {
        cin >> arr[i].l >> arr[i].r;
        arr[i].c = arr[i].center();
        arr[i].len = arr[i].length();
    }
    sort(arr, arr + n, cmp);
    compress(arr, n);

    int ans = 0;
    for(int i = 0; i < n; i++) {
        int cent = (lower_bound(v.begin(), v.end(), arr[i].c) - v.begin()) + 1;
        ans += get_val(cent, arr[i]);
        upd_range(arr[i].l, arr[i].r, v.size());
    }
    cout << ans << endl;
    return 0;
}