#include<bits/stdc++.h>
using namespace std;
#define MAXN 150007
#define ll long long
bool cmp(pair<ll,ll>a, pair<ll,ll>b)
{
   return a.second-a.first<b.second-b.first;
}
vector<ll> merge(vector<ll>& a, vector<ll>& b)
{
    vector<ll>v;
    ll n=a.size(), m=b.size();
    ll i=0, j=0;
    while(i<n && j<m)
    {
        if(a[i]<=b[j])
        {
            v.push_back(a[i]);
            i++;
        }
        else
        {
            v.push_back(b[j]);
            j++;
        }
    }
    for(ll k=i;k<n;k++)
    {
        v.push_back(a[k]);
    }
    for(ll k=j;k<m;k++)
    {
        v.push_back(b[k]);
    }

    return v;
}
void segTree(vector<ll>*tree, ll*a, ll index, ll s, ll edges)
{
    if(s==edges)
    {
        tree[index].push_back(a[s]);
        return;
    }

    ll m=(s+edges)/2;
    segTree(tree,a,2*index,s,m);
    segTree(tree,a,2*index+1,m+1,edges);

    tree[index]=merge(tree[2*index],tree[2*index+1]);
}
ll getQuery(vector<ll>*tree, ll index, ll s, ll e, ll l, ll r, ll k)
{
    if(r<s || l>e)
    {
        return 0;
    }
    if(s>=l && e<=r)
    {
        //int p=(tree[index].size()-(lower_bound(tree[index].begin(),tree[index].end(),k)-tree[index].begin()));
        //cerr<<p<<endl;
        return (tree[index].size()-(lower_bound(tree[index].begin(),tree[index].end(),k)-tree[index].begin()));
    }
    ll mid=(s+e)/2;
    return (getQuery(tree,2*index,s,mid,l,r,k)+getQuery(tree,2*index+1,mid+1,e,l,r,k));
}
ll solve(ll n, vector<ll>tree[], ll M[])
{
    ll sum=0;
    for(ll i=0;i<n-1;i++)
    {
        sum+=getQuery(tree,1,0,n-1,0,i,M[i]);
    }
    return sum;
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);cout.tie(0);
    ll n;
    vector<pair<ll,ll>>v;
    ll l1,r1;
    cin>>n;
    for(ll i=0;i<n;i++)
    {
        cin>>l1>>r1;
        v.emplace_back(l1*2,r1*2);
    }
    sort(v.begin(),v.end(),cmp);

    ll l[MAXN],r[MAXN];
    for(ll i=0;i<n;i++)
    {
        l[i]=v[i].first;
        r[i]=v[i].second;
    }
    vector<ll>treeRight[4*n+1], treeLeft[4*n+1];
    segTree(treeRight,r,1,0,n-1);
    segTree(treeLeft,l,1,0,n-1);
    ll mids[MAXN];
    for(ll i=0;i<n-1;i++)
    {
        mids[i]=(v[i+1].first+v[i+1].second)/2;
    }
    ll rightsum, leftsum;
    rightsum=solve(n,treeRight,mids);
    for(ll i=0;i<n-1;i++)
    {
        mids[i]++;
    }
    leftsum=solve(n,treeLeft,mids);
    //cerr<<rightsum<<endl<<leftsum<<endl;
    cout<<rightsum-leftsum<<endl;
    return 0;
}