#include <bits/stdc++.h>
#define ll long long
#define pb push_back
#define all(v) v.begin(), v.end()
#define sp ' '
#define en '\n'
#define bitcnt(x) (__builtin_popcountll(x))
#define lg(x) (63-__builtin_clzll(x))
#define highpow(x) (1LL<<lg(x))

using namespace std;

class segtree{

    int n;
    vector<ll> tree;

    void init(int s){
        n = highpow(s);
        if (bitcnt(s)>1) n <<= 1;
        tree.assign(2*n, 0);
    }

    ll update(int s, int l, int r, int pos, ll x){
        if (l > pos || r < pos) return tree[s];
        if (l == r) return tree[s] = x;
        int m = (l + r)>>1;
        ll a = update(2*s, l, m, pos, x);
        ll b = update(2*s+1, m+1, r, pos, x);
        return tree[s] = a + b;
    }

    ll query(int s, int l, int r, int ql, int qr) const {
        if (l > qr || r < ql) return 0;
        if (l >= ql && r <= qr) return tree[s];
        int m = (l + r)>>1;
        ll a = query(2*s, l, m, ql, qr);
        ll b = query(2*s+1, m+1, r, ql, qr);
        return a + b;
    }

public:
    segtree(int n){ init(n); }
    void update(int pos, ll x){ update(1, 0, n-1, pos, x); }
    ll query(int l, int r) const { if (l>r) return 0; return query(1, 0, n-1, l, r); }
};

void Resi(int N, int* A, int Q, int* T, int* L, int* R, int* S, ll* O) {

    segtree st(N+1);
    for (int i = 1; i <= N; i++) st.update(i, A[i]);
    n = N;
    for (int i = 1; i <= Q; i++){
        if (T[i] == 1){
            ll sum = 0;
            int j = 0;
            for (; j < S[i] && L[i]+j <= R[i]; j++)
                sum += (ll)A[L[i]+j] * (ll)(S[i] % (j+1));
            sum += (ll)S[i] * st.query(L[i]+j, R[i]);
            O[i] = sum;
        }
        else{
            st.update(L[i], R[i]);
            A[L[i]] = R[i];
        }
    }
}