#include <bits/stdc++.h>
#define ll long long
#define pb push_back
#define all(v) v.begin(), v.end()
#define sp ' '
#define en '\n'
#define pv(v) for (auto x : v) cout << x << sp; cout << en
#define bitcnt(x) (__builtin_popcountll(x))
#define lg(x) (63-__builtin_clzll(x))
#define highpow(x) (1LL<<lg(x))

using namespace std;

class segtree{

    int n;
    vector<int> tree;

    void init(int s){
        n = highpow(s);
        if (bitcnt(s) > 1) n <<= 1;
        tree.assign(2*n, 0);
    }

    int update(int s, int l, int r, int pos, int x){

        if (l > pos || r < pos) return tree[s];
        if (l == r) return tree[s] = x;
        int m = (l + r)>>1;
        int a = update(2*s, l, m, pos, x);
        int b = update(2*s+1, m+1, r, pos, x);
        return tree[s] = a + b;
    }

    int query(int s, int l, int r, int ql, int qr) const {

        if (l > qr || r < ql) return 0;
        if (l >= ql && r <= qr) return tree[s];
        int m = (l + r)>>1;
        int a = query(2*s, l, m, ql, qr);
        int b = query(2*s+1, m+1, r, ql, qr);
        return a + b;
    }

public:
    segtree(int n){ init(n); }
    void update(int pos, int x){ update(1, 0, n-1, pos, x); }
    int query(int l, int r) const { if (l>r) return 0; return query(1, 0, n-1, l, r); }
    void Print() const { for (int i = n; i < 2*n; i++) cout << tree[i] << sp; cout << en; }
};

const int mxN = 3e5+10;
int n, comp[mxN], sz[mxN], depth[mxN], in[mxN], out[mxN], par[mxN][21];
vector<int> g[mxN];
segtree* st;

void LCAinit(){

    for (int d = 1; d <= lg(n); d++)
        for (int s = 1; s <= n; s++)
            if (~par[s][d-1])
                par[s][d] = par[par[s][d-1]][d-1];
}
bool Ancestor(int s, int p){ return in[p] <= in[s] && out[p] >= out[s]; }
int Par(int s, int d){ if (!d) return s; return Par(par[s][lg(d)], d-highpow(d)); }
int Lca(int u, int v){
    if (depth[u] > depth[v]) swap(u, v);
    if (Ancestor(v, u)) return u;
    v = Par(v, depth[v] - depth[u]);
    for (int d = lg(n); ~d; d--){
        if (par[u][d]^par[v][d]){
            u = par[u][d];
            v = par[v][d];
        }
    }
    return par[u][0];
}

void dfs(int s, int c){

    comp[s] = c;
    for (int u : g[s])
        if (comp[u]^c)
            dfs(u, c);
}
bool Merge(int u, int v){

    if (comp[u] == comp[v]) return 0;
    if (sz[comp[u]] < sz[comp[v]]) swap(u, v);
    g[u].pb(v); g[v].pb(u);
    sz[comp[u]] += sz[comp[v]];
    sz[comp[v]] = 0;
    dfs(v, comp[u]);
    return 1;
}

int Euler(int s = 1, int p = 0, int d = 0, int t = 0){

    par[s][0] = p;
    depth[s] = d;
    in[s] = t;
    for (int u : g[s])
        if (u^p)
            t = Euler(u, s, d+1, t+1);
    return out[s] = ++t;
}



bool Moze(int u, int v){

    int s = Lca(u, v);
    return !(st->query(in[s]+1, in[u]) + st->query(in[s]+1, in[v]));
}

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {

    n = N;
    for (int i = 1; i <= N; i++){
        sz[i] = 1;
        comp[i] = i;
    }
    vector<array<int, 3> > edge;
    for (int i = 1; i <= M; i++)
        edge.pb({W[i], X[i], Y[i]});
    sort(all(edge));
    vector<array<int, 3> > a, b;
    for (auto e : edge){
        if (Merge(e[1], e[2])) a.pb(e);
        else b.pb(e);
    }
    reverse(all(a)); reverse(all(b));
/*
    for (int i = 1; i <= N; i++){
        cout << i << ": ";
        pv(g[i]);
    }
    cout << en;
    for (auto x : a) cout << x[0] << sp << x[1] << sp << x[2] << en;
    cout << en;
    for (auto x : b) cout << x[0] << sp << x[1] << sp << x[2] << en;
    cout << en;
*/
    Euler();
    LCAinit();
/*
    for (int i = 1; i <= N; i++)
        cout << in[i] << sp << out[i] << sp << depth[i] << en;
    for (int i = 1; i <= N; i++){
        for (int j = 0; j <= lg(N); j++)
            cout << par[i][j] << sp;
        cout << en;
    }
*/
    st = new segtree(2*N);
    for (int i = 2; i <= N; i++){
        st->update(in[i], 1);
        st->update(out[i], -1);
    }
    vector<int> r;
    int i = 0, j = 0;
    for (; i < a.size() && j < b.size();){
        if (b[j][0] > a[i][0] && Moze(b[j][1], b[j][2])) r.pb(b[j++][0]);
        else{
            int s = a[i][1];
            if (in[a[i][2]] > in[s]) s = a[i][2];
            st->update(in[s], 0);
            st->update(out[s], 0);
            r.pb(a[i++][0]);
        }
    }
    while (i < a.size()) r.pb(a[i++][0]);
    while (j < b.size()) r.pb(b[j++][0]);
    return r;
}