#include <bits/stdc++.h>
using namespace std;

const int N = 300000;
const int LOG = 20;

struct DSU{
    int par[N+5];
    int sz[N+5];
    int root(int x){ return (par[x] == x ? x : par[x] = root(par[x])); }
    void spoj(int u, int v){
        if(sz[u] < sz[v]) swap(u, v);
        par[v] = u;
        sz[u] += sz[v];
    }
} dsu;

int in[N+5], out[N+5];
vector <pair <int, int>> graf[N+5];

int par[N+5][LOG+1];
int w[N+5][LOG+1];

int tjm;

void dfs(int v, int p, int val){
    in[v] = ++tjm;
    par[v][0] = p;
    w[v][0] = val;
    for(int j=1; j<=LOG; j++){
        par[v][j] = par[par[v][j-1]][j-1];
        w[v][j] = min(w[v][j-1], w[par[v][j-1]][j-1]);
    }
    for(auto c : graf[v]){
        if(c.first == p) continue;
        dfs(c.first, v, c.second);
    }
    out[v] = tjm;
}

bool is_parent(int a, int b){
    return in[a] <= in[b] && out[b] <= out[a];
}

int lca(int a, int b){
    if(is_parent(a, b)) return a;
    for(int j=LOG; j>=0; j--){
        if(par[a][j] && !is_parent(par[a][j], b)) a = par[a][j];
    }
    return par[a][0];
}

int min_path(int a, int b){
    int x = lca(a, b);
    int res = 1e9;
    if(a != x){
        for(int j=LOG; j>=0; j--){
            if(par[a][j] && !is_parent(par[a][j], x)){
                res = min(res, w[a][j]);
                a = par[a][j];
            }
        }
        res = min(res, w[a][0]);
    }
    //if(a == 1) cout << "vidi " << x << endl;
    if(b != x){
        for(int j=LOG; j>=0; j--){
            if(par[b][j] && !is_parent(par[b][j], x)){
                res = min(res, w[b][j]);
                b = par[b][j];
                //if(a == 1) cout << "koristim " << j << endl;
            }
        }
        //if(a == 1) cout << "tren res" << res << endl;
        res = min(res, w[b][0]);
    }
    return res;
}

vector <tuple <int, int, int>> edges;
vector <int> after[N+5];
map <int, int> koji;

vector<int> NadjiPoredak(int _N, int M, int* X, int* Y, int* _W) {
    int n = _N;
    for(int i=1; i<=M; i++){
        edges.push_back({_W[i], X[i], Y[i]});
    }
    sort(edges.begin(), edges.end());
    for(int i=1; i<=n; i++){
        dsu.par[i] = i;
        dsu.sz[i] = 1;
    }
    vector <tuple <int, int, int>> ost;
    vector <int> prv;
    int th = 0;
    for(auto p : edges){
        int W = get<0>(p);
        int u = get<1>(p);
        int v = get<2>(p);
        int u1 = dsu.root(u);
        int v1 = dsu.root(v);
        if(u1 == v1) ost.push_back(p);
        else{
            //cout << u << " i " << v << " i " << W << endl;
            graf[u].push_back({v, W});
            graf[v].push_back({u, W});
            prv.push_back(W);
            koji[W] = ++th;
            dsu.spoj(u1, v1);
        }
    }
    dfs(1, 0, 0);
    for(auto p : ost){
        int W = get<0>(p);
        int u = get<1>(p);
        int v = get<2>(p);
        //cout << u << " in " << v << endl;
        int x = min_path(u, v);
        //cout << x << " how " << endl;
        after[koji[x]].push_back(W);
    }
    reverse(prv.begin(), prv.end());
    vector <int> sol;
    for(auto c : prv){
        sol.push_back(c);
        int h = koji[c];
        sort(after[h].begin(), after[h].end());
        reverse(after[h].begin(), after[h].end());
        for(auto y : after[h]) sol.push_back(y);
    }
    return sol;
}

/*
4 5
1 2 50
2 3 10
2 4 20
3 4 30
1 4 40
*/

/*
5 5
2 5 12
2 4 3
1 2 50
1 4 11
3 4 36
*/