#include <bits/stdc++.h>

using namespace std;

const int MAX = 100005;
const int B = 350;

int n;
int a[MAX];
long long pref[MAX];
long long spref[MAX];
bool was[MAX];

struct fenwick {
	long long fenw[MAX];
	fenwick() {
		for (int i = 0; i < MAX; i++) {
			fenw[i] = 0;
		}
	}
	void modify(int x, int v) {
		for (int i = x; i < MAX; i += i & -i) {
			fenw[i] += v;
		}
	}
	long long get(int x) {
		long long res = 0;
		for (int i = x; i > 0; i -= i & -i) {
			res += fenw[i];
		}
		return res;
	}
};

void build() {
	pref[0] = 0;
	spref[0] = 0;
	for (int i = 1; i <= n; i++) {
		pref[i] = pref[i - 1] + a[i];
		spref[i] = spref[i - 1] + a[i] * 1LL * (n - i + 1);
	}
}

bool check(int X) {
	vector<int> vec;
	for (int j = 1; j <= B; j++) {
		int v = X / j;
		if (v != 0) {
			vec.push_back(v + 1);
		}
		if (X >= j) {
			vec.push_back(j);
			if (j == B && X > j) {
				vec.push_back(j + 1);
			}
		}
	}
	sort(vec.begin(), vec.end());
	vec.erase(unique(vec.begin(), vec.end()), vec.end());
	for (int i = 0; i + 1 < vec.size(); i++) {
		int l = vec[i];
		int r = vec[i + 1] - 1;
		for (int j = l; j < r; j++) {
			assert(X % j == (X % (j + 1) + X / l));
		}
	}
}

void Resi(int N, int* A, int Q, int* T, int* L, int* R, int* S, long long* O) {
	n = N;
	for (int i = 1; i <= n; i++) {
		a[i] = A[i];
	}
	//for (int i = 90000; i <= 100000; i++) check(i);
	if (N <= 1000 && Q <= 1000 && false) {
		for (int i = 1; i <= Q; i++) {
			if (T[i] == 1) {
				O[i] = 0;
				for (int j = L[i]; j <= R[i]; j++) {
					int x = j - L[i] + 1;
					O[i] += (S[i] % x) * 1LL * A[j];
				}
			} else {
				A[L[i]] = R[i];
			}
		}
		return;
	}
	bool sub2 = true;
	for (int i = 1; i <= Q; i++) {
		if (T[i] == 1) {
			sub2 &= (S[i] <= 10);
		}
	}
	if (sub2 && false) {
		fenwick fenw;
		for (int i = 1; i <= n; i++) {
			fenw.modify(i, A[i]);
		}
		for (int i = 1; i <= Q; i++) {
			if (T[i] == 1) {
				int len = R[i] - L[i] + 1;
				O[i] = 0;
				if (len > S[i]) {
					O[i] += S[i] * 1LL * (fenw.get(R[i]) - fenw.get(L[i] + S[i] - 1));
				}
				for (int x = 0; x < min(len, S[i]); x++) {
					O[i] += A[L[i] + x] * 1LL * (S[i] % (x + 1));
				}
			} else {
				fenw.modify(L[i], R[i] - A[L[i]]);
				A[L[i]] = R[i];
			}
		}
		return;
	}
	build();
	for (int i = 1; i <= Q; i++) {
		if (T[i] == 1) {
			int len = R[i] - L[i] + 1;
			vector<int> vec;
			O[i] = 0;
			if (S[i] < len) {
				O[i] += (pref[R[i]] - pref[L[i] + S[i] - 1]) * (long long) S[i];
			}
			len = min(len, S[i]);
			if (S[i] <= B) {
				for (int x = 1; x <= S[i]; x++) {
					vec.push_back(x);
				}
			} else {
				for (int x = 1; x <= B; x++) {
					vec.push_back(x);
					was[x] = true;
				}
				for (int x = B; x >= 1; x--) {
					int v = S[i] / x;
					if (v != 0 && !was[v + 1]) {
						vec.push_back(v + 1);
						was[v + 1] = true;
					}
				}
			}
			for (int j = 0; j + 1 < vec.size(); j++) {
				int l = vec[j];
				int r = vec[j + 1] - 1;
				if (l > len) {
					break;
				}
				r = min(r, len);
				if (l > r) {
					break;
				}
				long long sum = pref[L[i] + r - 1] - pref[L[i] + l - 2];
				long long ssum = spref[L[i] + r - 1] - spref[L[i] + l - 2];
				int md = (S[i] % r);
				long long d = ssum - sum * (long long) ((n - (L[i] + r - 1) + 1));
				O[i] += d * (S[i] / l);
				O[i] += md * sum;
			}
			for (int j : vec) was[j] = false;
		} else {
			a[L[i]] = R[i];
			build();
		}
	}
}

/*
5
7 2 3 9 4
5
1 3 5 7
1 1 5 100
2 3 5
1 1 5 100
1 1 3 1
*/