#include <bits/stdc++.h>

using namespace std;

const int MAX = 300050;
const int L = 25;

int par[MAX], jump[MAX][L], go[MAX][L], ww[MAX], vis[MAX], dep[MAX], dh[MAX], hd[MAX];
vector<pair<int, int>> g[MAX];
bool spec[MAX];

int root(int x) {
	return par[x] == x ? x : par[x] = root(par[x]);
}

void unite(int x, int y) {
	x = root(x);
	y = root(y);
	if (x == y) {
		return;
	}
	par[x] = y;
}

void dfs(int u, int p) {
	jump[u][0] = p;
	dep[u] = dep[p] + 1;
	for (auto& e : g[u]) {
		int v = e.first;
		int w = e.second;
		if (v != p) {
			ww[v] = w;
			dfs(v, u);
		}
	}
}

void dfs_spec(int u, int p) {
	hd[u] = hd[p] + dh[u];
	for (auto& e : g[u]) {
		int v = e.first;
		if (v != p) {
			dfs_spec(v, u);
		}
	}
}

int lca(int u, int v) {
	if (dep[u] < dep[v]) {
		swap(u, v);
	}
	for (int i = L - 1; i >= 0; i--) {
		if (dep[jump[u][i]] >= dep[v]) {
			u = jump[u][i];
		}
	}
	if (u == v) {
		return u;
	}
	for (int j = L - 1; j >= 0; j--) {
		if (jump[u][j] != jump[v][j]) {
			u = jump[u][j];
			v = jump[v][j];
		}
	}
	return jump[u][0];
}

int getMinOnPath(int u, int v) {
	int l = lca(u, v);
	int mn = 1e9;
	for (int i = L - 1; i >= 0; i--) {
		if (dep[jump[u][i]] >= dep[l]) {
			mn = min(mn, go[u][i]);
			u = go[u][i];
		}
	}
	for (int i = L - 1; i >= 0; i--) {
		if (dep[jump[v][i]] >= dep[l]) {
			mn = min(mn, go[v][i]);
			v = go[v][i];
		}
	}
	return mn;
}

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {
	int order[M + 1];
	for (int i = 1; i <= M; i++) {
		order[i] = i;
	}
	sort(order + 1, order + M + 1, [&](int i, int j) {
		return W[i] < W[j];
	});
	for (int i = 1; i <= N; i++) {
		par[i] = i;
	}
	vector<int> mst;
	for (int j = 1; j <= M; j++) {
		int i = order[j];
		if (root(X[i]) != root(Y[i])) {
			unite(X[i], Y[i]);
			g[X[i]].emplace_back(Y[i], W[i]);
			g[Y[i]].emplace_back(X[i], W[i]);
			spec[i] = true;
			mst.push_back(i);
		}
	}
	reverse(mst.begin(), mst.end());
	dfs(1, 0);
	for (int i = 2; i <= N; i++) {
		go[i][0] = ww[i];
	}
	for (int j = 1; j < L; j++) {
		for (int i = 1; i <= N; i++) {
			jump[i][j] = jump[jump[i][j - 1]][j - 1];
		}
	}
	for (int j = 1; j < L; j++) {
		for (int i = 1; i <= N; i++) {
			go[i][j] = min(go[i][j - 1], go[jump[i][j - 1]][j - 1]);
		}
	}
	vector<int> ans;
	map<int, vector<int>> gasolina;
	for (int i = 1; i <= M; i++) {
		if (spec[i]) {
			continue;
		}
		int mn = getMinOnPath(X[i], Y[i]);
		gasolina[mn].push_back(W[i]);
	}
	for (int i = 2; i <= N; i++) {
		dh[i] = 1;
	}
	int L[M + 1];
	for (int j = 1; j <= M; j++) {
		L[j] = lca(X[j], Y[j]);
	}
	dfs_spec(1, 0);
	bool fin[M + 1];
	for (int i = 1; i <= M; i++) {
		fin[i] = false;
	}
	for (int i : mst) {
		int u = X[i];
		int v = Y[i];
		if (dep[u] < dep[v]) {
			swap(u, v);
		}
		dh[u] = 0;
		//dfs_spec(1, 0);
		ans.push_back(W[i]);
		/*for (int j = M; j >= 1; j--) {
			int i = order[j];
			if (spec[i] || fin[i]) {
				continue;
			}
			int tot = hd[X[i]] + hd[Y[i]] - 2 * hd[L[i]];
			if (tot == 0) {
				fin[i] = true;
				ans.push_back(W[i]);
			}
		}*/
		sort(gasolina[W[i]].rbegin(), gasolina[W[i]].rend());
		for (int xxx : gasolina[W[i]]) {
			ans.push_back(xxx);
		}
	}
  return ans;
}

/*
4 5
1 2 50
2 3 10
2 4 20
3 4 30
1 4 40

5 5
2 5 12
2 4 3
1 2 50
1 4 11
3 4 36

*/