#include <bits/stdc++.h>

using namespace std;

struct edge{
    int u, v, w, pos;

    edge(int u, int v, int w, int pos) : u(u), v(v), w(w), pos(pos) {};
};

vector<int> NadjiPoredak(int n, int m, int* x, int* y, int* w){
    vector<edge> ed;
    ed.reserve(m);

    for(int i = 1; i <= m; ++i) ed.emplace_back(*(x+i) - 1, *(y+i) - 1, *(w+i), i-1);

    sort(ed.begin(), ed.end(), [](edge& e1, edge& e2){
        if(e1.w < e2.w) return true;
        if(e1.w > e2.w) return false;
        if(e1.pos > e2.pos) return true;
        return false;
    });

    vector<int> p(n), siz(n, 1);

    for(int i = 0; i < n; ++i) p[i] = i;

    auto pfind = [&](int u){
        while(p[u] != u) u = p[u];

        return u;
    };

    auto unite = [&](int u, int v){
        if(siz[v] > siz[u]) p[u] = v, siz[v] += siz[u];
        else p[v] = u, siz[u] += siz[v];
    };

    vector<bool> usd(m);
    vector<int> usdEd, nEd;
    usdEd.reserve(m), nEd.reserve(m);

    for(int i = 0; i < m; ++i){
        int u = ed[i].u, v = ed[i].v, pos = ed[i].pos;
        int pu = pfind(u), pv = pfind(v);
        if(pu != pv) unite(pu, pv), usd[pos] = 1, usdEd.push_back(ed[i].w);
        else nEd.push_back(ed[i].w);
    }

    sort(usdEd.rbegin(), usdEd.rend());
    sort(nEd.rbegin(), nEd.rend());

    p = vector<int>(n), siz = vector<int>(n, 1);
    for(int i = 0; i < n; ++i) p[i] = i;

    vector<int> ans(m);
    int p1 = 0, p2 = 0;
    for(int i = 0; i < m; ++i){
        int u = ed[i].u, v = ed[i].v, pos = ed[i].pos;
        int pu = pfind(u), pv = pfind(v);
        if(pu != pv) unite(pu, pv), ans[i] = usdEd[p1++];
        else ans[i] = nEd[p2++];
    }

    return ans;
};