#include <bits/stdc++.h>

using namespace std;

struct edge{
    int u, v, w, pos;

    edge(int u, int v, int w, int pos) : u(u), v(v), w(w), pos(pos) {};
};

struct alEdge{
    int v, w, pos;

    alEdge(int v, int w, int pos) : v(v), w(w), pos(pos) {};
};

vector<int> NadjiPoredak(int n, int m, int* x, int* y, int* w){
    vector<edge> ed;
    ed.reserve(m);

    for(int i = 1; i <= m; ++i) ed.emplace_back(*(x+i) - 1, *(y+i) - 1, *(w+i), i-1);

    vector<int> p(n), siz(n, 1);

    for(int i = 0; i < n; ++i) p[i] = i;

    auto pfind = [&](int u){
        while(p[u] != u) u = p[u];

        return u;
    };

    auto unite = [&](int u, int v){
        if(siz[v] > siz[u]) p[u] = v, siz[v] += siz[u];
        else p[v] = u, siz[u] += siz[v];
    };

    vector<edge> sEd(ed);

    sort(sEd.begin(), sEd.end(), [](edge& e1, edge& e2){
        return e1.w < e2.w;
    });

    vector<vector<alEdge>> al(n);
    vector<edge> mstEd;
    mstEd.reserve(m);
    vector<bool> put(m);

    for(int i = 0; i < m; ++i){
        int u = sEd[i].u, v = sEd[i].v, w = sEd[i].w, pos = sEd[i].pos;
        int pu = pfind(u), pv = pfind(v);
        al[u].emplace_back(v, w, pos);
        al[v].emplace_back(u, w, pos);

        if(pu != pv) unite(pu, pv), mstEd.emplace_back(u, v, w, pos), put[pos] = 1;
    }

    sort(mstEd.begin(), mstEd.end(), [](edge& e1, edge& e2){
        return e1.w < e2.w;
    });

    siz = vector<int>(n, 1);
    for(int i = 0; i < n; ++i) p[i] = i;

    set<int> av;
    vector<int> ans(m);

    auto aunite = [&](int u, int v){
        if(siz[v] > siz[u]) p[u] = v, siz[v] += siz[u];
        else p[v] = u, siz[u] += siz[v];

        int tmp = pfind(u);
        for(alEdge i : al[u]){
            if(put[i.pos]) continue;
            if(pfind(i.v) == tmp) av.insert(i.w), put[i.pos] = 1;
        }
        tmp = pfind(v);
        for(alEdge i : al[v]){
            if(put[i.pos]) continue;
            if(pfind(i.v) == tmp) av.insert(i.w), put[i.pos] = 1;
        }
    };

    int ind = 0;
    while(ind < m){
        if(av.empty()){
            int u = mstEd.back().u, v = mstEd.back().v, w = mstEd.back().w;
            ans[ind++] = w;
            aunite(pfind(u), pfind(v));
            mstEd.pop_back();
        }else if(mstEd.empty()){
            ans[ind++] = *av.rbegin();
            av.erase(*av.rbegin());
        }else if(*av.rbegin() > mstEd.back().w){
            ans[ind++] = *av.rbegin();
            av.erase(*av.rbegin());
        }else{
            int u = mstEd.back().u, v = mstEd.back().v, w = mstEd.back().w;
            ans[ind++] = w;
            aunite(pfind(u), pfind(v));
            mstEd.pop_back();
        }
    }

    return ans;
};