#include <bits/stdc++.h>

#define pb push_back
#define MAXN 300010
using namespace std;

class subset {

public:
    int Parent, Rank;
    subset() {
        Parent = -1;
        Rank = 1;
    }
};

subset s[MAXN];

int Find(int x) {

    if(s[x].Parent == -1)
        return x;
    return (s[x].Parent = Find(s[x].Parent));
}

void append(int x, int root) {

    s[x].Parent = root;
    s[root].Rank += s[x].Rank;
}

void Union(int x, int y) {

    int a = Find(x),
        b = Find(y);

    if(s[a].Rank > s[b].Rank)
        append(b, a);
    else
        append(a, b);
}

vector<bool> inMST(MAXN, false);

vector<int> getMST(vector< tuple<int, int, int> > edges, int mx) {

    for(int i = 0; i <= mx; i++)
        s[i].Parent = -1, s[i].Rank = 1;
    vector<int> mst;
    int n = edges.size();
    for(int i = 0; i < n; i++) {
        int w, u, v;
        tie(w, u, v) = edges[i];

        if(Find(u) != Find(v)) {
            Union(u, v);
            mst.pb(w);
        }
    }
    sort(mst.begin(), mst.end(), greater<int>());
    return mst;
}

vector< tuple<int, int, int> > getMST2(vector< tuple<int, int, int> > edges, int mx) {

    for(int i = 0; i <= mx; i++)
        s[i].Parent = -1, s[i].Rank = 1;
    vector< tuple<int, int, int> > mst;
    int n = edges.size();
    for(int i = 0; i < n; i++) {
        int w, u, v;
        tie(w, u, v) = edges[i];

        if(Find(u) != Find(v)) {
            Union(u, v);
            mst.pb({w, u, v});
            inMST[w] = true;
        }
    }
    sort(mst.begin(), mst.end(), greater< tuple<int, int, int> >());
    return mst;
}

bool cmp(vector< tuple<int, int, int> > a, vector< tuple<int, int, int> > b) {

    for(int i = 0; i < a.size(); i++) {
        int va = get<0>(a[i]), vb = get<0>(b[i]);
        if(va > vb)
            return true;
        if(vb > va)
            return false;
    }
    return false;
}

vector< pair<int, int> > graph[MAXN];
int dt[MAXN], ft[MAXN], tim = 0, parent[MAXN];

void dfs(int u, int p) {

    dt[u] = tim++;
    parent[u] = p;
    for(auto k: graph[u]) {
        int v = k.first;
        if(v != p)
            dfs(v, u);
    }
    ft[u] = tim++;
}

bool up(int a, int b) {

    return (dt[a] <= dt[b] && ft[b] <= ft[a]);
}

int find_min(int u, int p, int src, int dest) {

    for(auto k: graph[u]) {
        int v = k.first;
        if(v == p)
            continue;
        if(up(v, src) + up(v, dest) == 1)
            return min(find_min(v, u, src, dest), k.second);
    }

    for(auto k: graph[u]) {
        int v = k.first;
        if(v == p)
            continue;
        if(up(v, src) && up(v, dest))
            return min(find_min(v, u, src, dest), k.second);
    }
    return 1111111;
}

map< int, vector<int> > ve;

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {

    vector< tuple<int, int, int> > edges;
    map<int, int> U, V;
    for(int i = 1; i <= M; i++) {
        edges.pb({ W[i], X[i], Y[i] });
        U[W[i]] = X[i];
        V[W[i]] = Y[i];
    }
    sort(edges.begin(), edges.end());

    if(M <= 9) {
        vector< tuple<int, int, int> > sol(M);
        vector<int> mst = getMST(edges, N);
        vector< tuple<int, int, int> > edges2 = edges;
        while(true) {
            vector<int> temp = getMST(edges2, N);

            if(temp == mst && cmp(edges2, sol))
                sol = edges2;

            next_permutation(edges2.begin(), edges2.end());
            if(edges2 == edges)
                break;
        }

        vector<int> ans;
        for(auto k: sol)
            ans.pb(get<0>(k));
        return ans;
    }

    vector< tuple<int, int, int> > mst = getMST2(edges, N);
    int n = mst.size();
    for(int i = 0; i < n; i++) {
        int w, u, v;
        tie(w, u, v) = mst[i];

        graph[u].pb({v, w});
        graph[v].pb({u, w});
    }
    dfs(1, 0);

    for(int i = M - 1; i >= 0; i--) {
        int w, u, v;
        tie(w, u, v) = edges[i];

        if(inMST[w])
            continue;

        int mn = find_min(u, 0, u, v);
        ve[mn].pb(w);
    }

    vector<int> sol;
    priority_queue<int> pq;
    for(int i = 0; i < n; i++) {
        int w = get<0>(mst[i]);
        while(!pq.empty()) {
            int x = pq.top();

            if(x > w) {
                sol.pb(x);
                pq.pop();
            } else break;
        }
        sol.pb(w);

        for(int k: ve[w])
            pq.push(k);
    }
    while(!pq.empty()) {
        int x = pq.top();

        sol.pb(x);
        pq.pop();
    }
    return sol;
}