#include <bits/stdc++.h>

using namespace std;

const int N = 3e5 + 10;
//vector<int> g[N];

struct DSU {
    int n;
    vector<int> parent;
    DSU(int _n) { n = _n; parent.resize(n + 1); for(int i = 1; i <= n; i++) parent[i] = i; }
    int find_parent(int u) {
        if(u == parent[u]) return u;
        return parent[u] = find_parent(parent[u]);
    }
    bool check(int u, int v) { return parent[u] == parent[v]; } // kritican deo
    void mrg(int u, int v) {
        u = find_parent(u);
        v = find_parent(v);
        if(u != v) parent[v] = u;
    }
};

struct edge {
    int v;
    int w;
};

vector<int> valid;

bool ok(int n, int m, vector<int> have, int index, int nw, int* x, int* y, int* w) {
    have.push_back(nw);
    for(int i = have.size() - 1; i > index + 1; i--) swap(have[i], have[i - 1]);
    DSU dsu(n);
    vector<int> vec;
    for(int i = 0; i < have.size(); i++) {
        if(!dsu.check(x[have[i]], y[have[i]])) {
            dsu.mrg(x[have[i]], y[have[i]]);
            vec.push_back(have[i]);
        }
    }
    sort(vec.begin(), vec.end());
    return valid == vec;
}

vector<int> NadjiPoredak(int n, int m, int* x, int* y, int* w) {
//    for(int i = 1; i <= m; i++) {
//        g[x[i]].push_back({y[i], w[i]});
//        g[y[i]].push_back({x[i], w[i]});
//    }
    vector<int> have, need;
    DSU dsu(n);
    int order[m + 1];
    for(int i = 1; i <= m; i++) order[i] = i;
    sort(order + 1, order + m + 1, [&](int i, int j) {
        return w[i] < w[j];
    });
    for(int i = 1; i <= m; i++) {
        int ii = i;
        i = order[i];
        if(!dsu.check(x[i], y[i])) {
            dsu.mrg(x[i], y[i]);
            have.push_back(i);
        } else need.push_back(i);
        i = ii;
    }
    valid = have;
    sort(valid.begin(), valid.end());
    sort(have.begin(), have.end(), [&](int i, int j) {
        return w[i] > w[j];
    });
    sort(need.begin(), need.end(), [&](int i, int j) {
        return w[i] > w[j];
    });
    for(int cur = 0; cur < need.size(); cur++) {
        int l = 0, r = have.size() - 1;
        int ans = r;
        for(; l < have.size(); l++) if(w[have[l]] < w[need[cur]]) break;
        if(l > 0) l--;
        while(l <= r) {
            int mid = (l + r) >> 1;
            if(ok(n, m, have, mid, need[cur], x, y, w)) {
                ans = mid;
                r = mid - 1;
            } else l = mid + 1;
        }
        have.push_back(need[cur]);
        for(int i = have.size() - 1; i > ans + 1; i--) swap(have[i], have[i - 1]);
    }
    for(int i = 0; i < have.size(); i++) have[i] = w[have[i]];
    return have;
}
/*
4 5
1 2 50
2 3 10
2 4 20
3 4 30
1 4 40
*/