#include <bits/stdc++.h>

using namespace std;

struct edge{
    int u, v, w;

    edge(int u, int v, int w) : u(u), v(v), w(w) {};
};

struct alEdge{
    int v, w;

    alEdge(int v, int w) : v(v), w(w) {};
};

vector<int> NadjiPoredak(int n, int m, int* x, int* y, int* w){
    vector<edge> ed;
    ed.reserve(m);

    for(int i = 1; i <= m; ++i) ed.emplace_back(*(x+i) - 1, *(y+i) - 1, *(w+i));

    vector<int> p(n), siz(n, 1);

    for(int i = 0; i < n; ++i) p[i] = i;

    auto pfind = [&](int u){
        while(p[u] != u) u = p[u];

        return u;
    };

    auto unite = [&](int u, int v){
        if(siz[v] > siz[u]) p[u] = v, siz[v] += siz[u];
        else p[v] = u, siz[u] += siz[v];
    };

    vector<edge> sEd(ed);

    sort(sEd.begin(), sEd.end(), [](edge& e1, edge& e2){
        return e1.w < e2.w;
    });

    vector<vector<alEdge>> al(n);
    vector<edge> mstEd;
    mstEd.reserve(m);

    for(int i = 0; i < m; ++i){
        int u = sEd[i].u, v = sEd[i].v, w = sEd[i].w;
        int pu = pfind(u), pv = pfind(v);
        al[u].emplace_back(v, w);
        al[v].emplace_back(u, w);

        if(pu != pv) unite(pu, pv), mstEd.emplace_back(u, v, w);
    }

    sort(mstEd.begin(), mstEd.end(), [](edge& e1, edge& e2){
        return e1.w < e2.w;
    });

    siz = vector<int>(n, 1);
    for(int i = 0; i < n; ++i) p[i] = i;

    set<int> av;
    vector<int> ans(m);
    int ind = 0;

    auto aunite = [&](int u, int v){
        if(siz[v] > siz[u]) p[u] = v, siz[v] += siz[u];
        else p[v] = u, siz[u] += siz[v];

        int tmp = pfind(u);
        for(alEdge i : al[u]){
            if(pfind(i.v) == tmp) av.insert(i.w);
        }
        tmp = pfind(v);
        for(alEdge i : al[v]){
            if(pfind(i.v) == tmp) av.insert(i.w);
        }
    };

    while(ind != m){
        if(av.empty()){
            int u = mstEd.back().u, v = mstEd.back().v, w = mstEd.back().w;
            ans[ind++] = w;
            aunite(pfind(u), pfind(v));
            mstEd.pop_back();
        }else if(mstEd.empty() || *av.rbegin() > mstEd.back().w){
            ans[ind++] = *av.rbegin();
            av.erase(*av.rbegin());
        }else{
            int u = mstEd.back().u, v = mstEd.back().v, w = mstEd.back().w;
            ans[ind++] = w;
            aunite(pfind(u), pfind(v));
            mstEd.pop_back();
        }
    }

    return ans;
};