#include <bits/stdc++.h>

#define pb push_back
#define MAXN 300010
using namespace std;

class subset {

public:
    int Parent, Rank;
    subset() {
        Parent = -1;
        Rank = 1;
    }
};

subset s[MAXN];

int Find(int x) {

    if(s[x].Parent == -1)
        return x;
    return (s[x].Parent = Find(s[x].Parent));
}

void append(int x, int root) {

    s[x].Parent = root;
    s[root].Rank += s[x].Rank;
}

void Union(int x, int y) {

    int a = Find(x),
        b = Find(y);

    if(s[a].Rank > s[b].Rank)
        append(b, a);
    else
        append(a, b);
}

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {

    vector< tuple<int, int, int> > edges;
    for(int i = 1; i <= M; i++)
        edges.pb({ W[i], X[i], Y[i] });
    sort(edges.begin(), edges.end());

    vector< tuple<int, int, int> > mst;

    vector<bool> inMst(M, false);
    int n = edges.size();
    for(int i = 0; i < n; i++) {
        int w, u, v;
        tie(w, u, v) = edges[i];

        if(Find(u) != Find(v)) {
            Union(u, v);
            mst.pb({w, u, v});
            inMst[w] = true;
        }
    }

    for(int i = 0; i < MAXN; i++)
        s[i].Parent = -1, s[i].Rank = 1;
    sort(mst.begin(), mst.end(), greater< tuple<int, int, int> >());

    vector< tuple<int, int, int> > lft;
    for(int i = 0; i < n; i++)
        if(!inMst[get<0>(edges[i])])
            lft.pb(edges[i]);

    vector<bool> visited(M, false);
    vector<int> sol;
    for(int i = 0; i < mst.size(); i++) {
        int w, u, v;
        tie(w, u, v) = mst[i];

        int nxt = -1;
        if(i < mst.size() - 1)
            nxt = get<0>(mst[i + 1]);

        Union(u, v);
        sol.pb(w);

        for(int j = lft.size() - 1; j >= 0; j--) {
            int w1, u1, v1;
            tie(w1, u1, v1) = lft[j];

            if(w1 < nxt)
                break;
            if(!visited[w1] && Find(u1) == Find(v1)) {
                visited[w1] = true;
                sol.pb(w1);
            }
        }
    }
    return sol;
}