#include <bits/stdc++.h>
using namespace std;

#define pb push_back

struct edge{
    int w, x, y;

    bool operator < (const edge& other) const{
        return w < other.w;
    }
};

edge edges[5005];
int root[5005], sizee[5005];
bool visited[5005];
int res1[5005], res1Cnt;
map<pair<int, int>, bool> inmst;
unordered_map<int, int> pos;
vector<pair<int, int>> g[5005];
vector<int> vec[5005];
pair<int, int> par[5005];
set<int> s;

int findRoot(int x)
{
    if(root[x] == x){
        return x;
    }

    int xRoot = findRoot(root[x]);
    root[x] = xRoot;
    return root[x];
}

int findMax(int node, int theEnd, int curMax)
{
    if(node == theEnd){
        return curMax;
    }

    return findMax(par[node].first, theEnd, max(curMax, pos[par[node].second]));
}

void dfs(int node, int curMax)
{
    visited[node] = true;

    for(auto c : g[node]){
        if(visited[c.first] && !inmst[{node, c.first}]){
            int maxx = findMax(node, c.first, -1);
            vec[maxx].pb(c.second);
        }
    }

    for(auto c : g[node]){
        if(!visited[c.first] && inmst[{node, c.first}]){
            par[c.first] = {node, c.second};
            dfs(c.first, max(curMax, pos[c.second]));
        }
    }
}

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {
    for(int i = 1; i <= M; ++i){
        edges[i - 1].w = W[i];
        edges[i - 1].x = X[i];
        edges[i - 1].y = Y[i];

        g[X[i]].pb({Y[i], W[i]});
        g[Y[i]].pb({X[i], W[i]});
    }

    sort(edges, edges + M);

    for(int i = 1; i <= N; ++i){
        root[i] = i;
        sizee[i] = 1;
    }

    for(int i = 0; i < M; ++i){
        if(findRoot(edges[i].x) != findRoot(edges[i].y)){
            inmst[{edges[i].x, edges[i].y}] = inmst[{edges[i].y, edges[i].x}] = true;

            if(sizee[root[edges[i].x]] < sizee[root[edges[i].y]]){
                root[root[edges[i].x]] = root[edges[i].y];
                sizee[root[edges[i].y]] += sizee[root[edges[i].x]];
            }
            else{
                root[root[edges[i].y]] = root[edges[i].x];
                sizee[root[edges[i].x]] += sizee[root[edges[i].y]];
            }
        }
    }

    res1Cnt = 0;
    for(int i = 0; i < M; ++i){
        if(inmst[{edges[i].x, edges[i].y}]){
            res1[res1Cnt++] = edges[i].w;
        }
    }

    sort(res1, res1 + res1Cnt);
    reverse(res1, res1 + res1Cnt);

    for(int i = 0; i < res1Cnt; ++i){
        pos[res1[i]] = i;
    }

    dfs(1, -1);

    vector<int> res;
    for(int i = 0; i < res1Cnt; ++i){
        while(!s.empty() && *s.rbegin() > res1[i]){
            res.pb(*s.rbegin());
            s.erase(*s.rbegin());
        }

        res.pb(res1[i]);

        for(auto x : vec[i]){
            s.insert(x);
        }
    }
    while(!s.empty()){
        res.pb(*s.rbegin());
        s.erase(*s.rbegin());
    }

    return res;
}