#include <iostream>
#include <bits/stdc++.h>
using namespace std;
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>
using namespace __gnu_pbds;
typedef long long ll;
typedef tree<int,null_type,less<int>,rb_tree_tag,tree_order_statistics_node_update> order_set;
mt19937 mt_rand(chrono::high_resolution_clock::now().time_since_epoch().count());
const int mxN=5e5;
const int mxlogN=20;
struct DSU
{
    vector<int> size, p;
    void build(int n)
    {
        size=vector<int>(n,1);
        p=vector<int>(n);
        iota(p.begin(),p.end(),0);
    }
    int get(int x)
    {
        if(p[x]!=x) p[x]=get(p[x]);
        return p[x];
    }
    bool unite(int a, int b)
    {
        a=get(a), b=get(b);
        if(a==b) return 0;
        if(size[a]>size[b]) swap(a,b);
        p[a]=b;
        size[b]+=size[a];
        return 1;
    }
};
struct edge
{
    int u,v,w;
    int other(int i)
    {
        return i^u^v;
    }
    bool operator<(const edge& e) const
    {
        return w<e.w;
    }
    bool operator>(const edge& e) const
    {
        return w>e.w;
    }
};
vector<edge> adj[mxN];
int up[mxlogN][mxN], upw[mxlogN][mxN];
int down[mxN];
void dfs(int i, int d=0, int p=0, int pw=1e9)
{
    up[0][i]=p;
    upw[0][i]=pw;
    down[i]=d;
    for(int j=1; j<mxlogN; j++)
    {
        up[j][i]=up[j-1][up[j-1][i]];
        upw[j][i]=min(upw[j-1][i],upw[j-1][up[j-1][i]]);
    }
    for(auto e:adj[i])
    {
        int j=e.other(i);
        if(p==j) continue;
        dfs(j,d+1,i,e.w);
    }
}
int goup(int u, int x)
{
    for(int j=0; j<mxlogN; j++)
    {
        if(x&(1<<j)) u=up[j][u];
    }
    return u;
}
int LCA(int u, int v)
{
    if(down[u]<down[v]) swap(u,v);
    u=goup(u, down[u]-down[v]);
    if(u==v) return u;
    for(int j=mxlogN-1; j>=0; j--)
    {
        if(up[j][u]!=up[j][v])
        {
            u=up[j][u];
            v=up[j][v];
        }
    }
    return up[0][u];
}
int qry2(int u, int x)
{
    int mn=1e9;
    for(int j=0; j<mxlogN; j++)
    {
        if(x&(1<<j))
        {
            mn=min(mn,upw[j][u]);
            u=up[j][u];
        }
    }
    return mn;
}
int qry(int u, int v)
{
    int lca=LCA(u,v);
    //cout << "lca " << lca << "\n";
    return min(qry2(u, down[u]-down[lca]),qry2(v, down[v]-down[lca]));
}
vector<int> NadjiPoredak(int n, int m, int* X, int* Y, int* W)
{
    vector<edge> es;
    vector<edge> edg;
    for(int i=1; i<=m; i++) edg.push_back({X[i]-1,Y[i]-1,W[i]});
    sort(edg.begin(), edg.end(), less<edge>());
    DSU dsu;
    dsu.build(n);
    set<int> ok;
    for(auto e:edg)
    {
        if(dsu.unite(e.u,e.v))
        {
            ok.insert(e.w);
            //cout << "edge je " << e.w << "\n";
            adj[e.u].push_back(e);
            adj[e.v].push_back(e);
        }
    }
    dfs(0);
    //cout << "BURAG " << upw[1][1] << "\n";
    sort(edg.begin(), edg.end(), greater<edge>());
    vector<int> ans;
    map<int, vector<int>> who;
    for(auto e:edg)
    {
        //cout << "yeah " << e.w << "\n";
        if(ok.count(e.w))
        {
            ans.push_back(e.w);
            for(auto w2:who[e.w]) ans.push_back(w2);
        }
        else
        {
            //cout << "ovde " << e.w << "\n";
            int mn=qry(e.u, e.v);
            //cout << "mn " << mn << "\n";
            //cout << e.u << " " << e.v << "\n";
            if(mn>e.w) ans.push_back(e.w);
            else who[mn].push_back(e.w);
        }
    }
    return ans;
}
/*
int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, m; cin >> n >> m;
    int X[m+1], Y[m+1], W[m+1];
    for(int i=1; i<=m; i++) cin >> X[i];
    for(int i=1; i<=m; i++) cin >> Y[i];
    for(int i=1; i<=m; i++) cin >> W[i];
    auto ans=NadjiPoredak(n,m,X,Y,W);
    for(int i:ans) cout << i << " ";
}*/
/*
4 5
1 2 2 3 1
2 3 4 4 4
50 10 20 30 40
*/