#include <cstdio>

#include <algorithm>
#include <iostream>
#include <iomanip>
#include <numeric>
#include <vector>
#include <string>
#include <set>
#include <map>

using namespace std;
typedef long long ll;

class SegmentTree
{
public:
	SegmentTree(const vector<ll>& elements);
	void update(int pos, ll new_val);
	ll sum_query(int l, int r);
	ll element_at_pos(int i);
private:
	vector<ll> tree;
	int element_cnt;
};

ll bruteforce(const vector<ll>& elements, int s, int l, int r)
{
	ll sum = 0;
	int j = 1;
	int i = l;
	for (i; i < r; i++)
	{
		sum += elements[i] * (s % j);
		j++;
	}
	return sum;
}

ll solve_bruteforce(SegmentTree& tree, ll s, int l, int r)
{
	ll sol = 0;
	int j = 1;
	int i = l;
	for (i; i < r && s >= j; i++)
	{
		sol += tree.element_at_pos(i) * (s % j);
		j++;
	}
	if (i < r)
	{
		sol += tree.sum_query(i, r) * s;
	}
	return sol;
}

void Resi(int N, int* A, int Q, int* T, int* L, int* R, int* S, ll* O) {
	vector<ll> elements(N);
	for (int i = 1; i <= N; i++)
		elements[i-1] = A[i];
	auto tree = SegmentTree(elements);
	for (int i = 1; i <= Q; ++i) {
		if (T[i] == 1) {
			O[i] = solve_bruteforce(tree, S[i], L[i] - 1, R[i]);
		}
		else {
			tree.update(L[i]-1, R[i]);
		}
	}
}

SegmentTree::SegmentTree(const vector<ll>& elements)
{
	element_cnt = elements.size();
	tree = vector<ll>(2 * element_cnt);
	copy(elements.begin(), elements.end(), tree.begin() + element_cnt);
	for (int i = element_cnt - 1; i > 0; i--)
		tree[i] = tree[2 * i] + tree[2 * i + 1];
}

void SegmentTree::update(int pos, ll new_val)
{
	pos += element_cnt;
	tree[pos] = new_val;
	for (int i = pos / 2; i > 0; i /= 2)
		tree[i] = tree[2 * i] + tree[2 * i + 1];

}

ll SegmentTree::sum_query(int l, int r)
{
	l += element_cnt;
	r += element_cnt;
	ll sum = 0;
	while (l < r)
	{
		if (l % 2 == 1)
		{
			sum += tree[l++];
		}
		if (r % 2 == 1)
		{
			sum += tree[--r];
		}
		l /= 2;
		r /= 2;
	}
	return sum;
}

ll SegmentTree::element_at_pos(int i)
{
	return tree[i + element_cnt];
}