#include <algorithm>
#include <iostream>
#include <vector>
#include <numeric>
using namespace std;
typedef long long ll;

class DSU
{
public:
    DSU(int max_n);
    int find_set(int x);
    void join_elements(int x, int y);
private:
    vector<int> representative;
    vector<int> depth;
};

int solve_given_order(int* X, int* Y, int* W, const vector<int>& order, int n)
{
    DSU dsu(n);
    ll cost = 0;
    for (int i = 0; i < order.size(); i++)
    {
        int u = X[order[i] + 1]-1; int v = Y[order[i] + 1]-1;
        if (dsu.find_set(u) != dsu.find_set(v))
        {
            cost += W[order[i] + 1];
            dsu.join_elements(u, v);
        }
    }
    return cost;
}

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {
    vector<int> indices(M);
    iota(indices.begin(), indices.end(), 0);
    ll min_cost = LLONG_MAX; vector<int> best_vec;
    do
    {
        ll current_cost = solve_given_order(X, Y, W, indices, N);
        if (current_cost < min_cost)
        {
            vector<int> current_weights(M);
            for (int i = 0; i < M; i++)
                current_weights[i] = W[indices[i] + 1];

            min_cost = current_cost;
            current_cost = solve_given_order(X, Y, W, indices, N);
            best_vec = current_weights;
        }
        else if (current_cost == min_cost)
        {
            vector<int> current_weights(M);
            for (int i = 0; i < M; i++)
                current_weights[i] = W[indices[i] + 1];
            
            if (lexicographical_compare(best_vec.begin(),best_vec.end(),current_weights.begin(),current_weights.end()))
            {
                best_vec = current_weights;
            }
        }
    } while (next_permutation(indices.begin(), indices.end()));
	return best_vec;
}


DSU::DSU(int max_n)
{
    representative = vector<int>(max_n);
    iota(representative.begin(), representative.end(), 0);
    depth = vector<int>(max_n,1);
}

int DSU::find_set(int x)
{
    if (representative[x] == x)
        return x;
    representative[x] = find_set(representative[x]);
    return representative[x];
}

void DSU::join_elements(int x, int y)
{
    int s1 = find_set(x);
    int s2 = find_set(y);
    if (s1 != s2)
    {
        if (depth[s1] > depth[s2])
            swap(s1, s2);
        representative[s2] = s1;
        if (depth[s1] == depth[s2])
            depth[s1]++;
    }   
}