#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <cmath>
#include <iostream>
using namespace std;
const int oo = 3e5 + 7;
int cale[oo], mudo[oo];
int cukundeda(int a) {
    if (cale[a] == a) return a;
    return cale[a] = cukundeda(cale[a]);
}
void ujedini(int a, int b) {
    a = cukundeda(a);
    b = cukundeda(b);
    if (a == b) return;
    if (mudo[a] < mudo[b]) swap(a, b);
    cale[b] = a;
    if (mudo[a] == mudo[b]) mudo[a]++;
}
bool porodica(int a, int b) {
    return cukundeda(a) == cukundeda(b);
}
void repopulisi(int N) {
    for (int i = 1; i <= N; i++) cale[i] = i, mudo[i] = 0;
}
struct veza {
    int cena;
    int x, y;
    int id;
    bool operator< (veza b) const {
        return cena < b.cena;
    }
};
struct lcatree {
    vector<int> height;
    vector<int> euler;
    vector<int> first;
    vector<int> segm;
    vector<bool> visited;
    int n, root, segml;
    lcatree(vector<vector<int>>& edges, int _n, int _root) {
        n = _n;
        root = _root;
        segml = n * 2;
        height.assign(n, 0);
        first.assign(n, 0);
        euler.reserve(n * 2);
        visited.assign(n, false);
        dfs(edges, root);
        segm.assign(segml * 4, 0);
        build(1, 0, segml - 1);
    }
    void build(int v, int l, int r) {
        if (l == r) {
            segm[v] = euler[l];
            //cout << "na " << v << " je " << euler[l] << " , " << l << endl;
            return;
        }
        int mid = (l+r)/2;
        build(v*2, l, mid);
        build(v*2+1, mid+1, r);
        int ll = segm[v*2];
        int rr = segm[v*2+1];
        segm[v] = (height[ll] < height[rr]) ? ll : rr;
    }
    int kveri(int v, int l, int r, int L, int R) {
        //cout << "kveri na [" << l << ", " << r << "]" << endl;
        if (l > R || r < L)
            return -1;
        if (l >= L && r <= R)
            return segm[v];
        int m = (l+r)/2;
        int ll = kveri(v*2, l, m, L, R);
        int rr = kveri(v*2+1, m+1, r, L, R);
        if (ll == -1) return rr;
        if (rr == -1) return ll;
        return height[ll] < height[rr] ? ll : rr;
    }
    void dfs(vector<vector<int>>& edges, int v, int h = 0) {
        visited[v] = true;
        height[v] = h;
        first[v] = euler.size();
        euler.push_back(v);
        for (auto to : edges[v]) {
            if (!visited[to]) {
                dfs(edges, to, h + 1);
                euler.push_back(v);
            }
        }
    }
    int lca(int a, int b) {
        int l = first[a], r = first[b];
        if (l > r) swap(l, r);
        return kveri(1, 0, segml - 1, l, r);
    }
};
struct Tree {
    vector<int> maxt[20];
    vector<int> cale[20];
    vector<int> times;
    vector<int> level;
    vector<int> revtimes;
    vector<bool> exist;
    vector<int> eidfromvertex;
    int N, M, root;
    vector<vector<int>> edges;
    vector<int> real;
    lcatree* lt;
    Tree(int N, int M, vector<veza>& _edges,  int _times[oo]) {
        this->N = N;
        this->M = M;
        times.assign(N+1, 0);
        level.assign(N+1, 0);
        for (int i = 0; i < 20; i++) {
            maxt[i].assign(N+1, 0);
            cale[i].assign(N+1, 0);
        }
        revtimes.assign(M+1, 0);
        exist.assign(N+1, 0);
        eidfromvertex.assign(N+1, 0);
        root = -1;
        edges.assign(M+1, {});
        for (veza vv: _edges) {
            //cout << "edges veza " << vv.x << " sa " << vv.y << " id " << vv.id << endl;
            edges[vv.x].push_back(vv.y);
            edges[vv.y].push_back(vv.x);
            exist[vv.x] = exist[vv.y] = 1;
            root = vv.x;
        }
        for (int i = 1; i <= N; i++) if (exist[i]) real.push_back(i);

        if (root == -1) throw 1;
        //cout << "naso root " << root << endl;
        dfsmakelevel(root, -1, 0);
        //cout << "naso nivoe" << endl;
        dfsmakecale(root, -1);
        //cout << "napravio tatu" << endl;
        //cout << "ocevi: " << endl;
        //for (int i = 1; i <= N; i++) if (exist[i]) cout << "cale od " << i << " je " << cale[0][i] << endl;
        //for (int i = 1; i <= N; i++) for (int j: edges[i]) cout << "[" << i << " " << j << "]" << endl;
        for (veza vv: _edges) {
            int x = vv.x, y = vv.y;
            //cout << "raspoznava " << x << " i " << y << endl;
            if (cale[0][x] == y) swap(x, y);
            if (cale[0][y] != x) throw 2;
            eidfromvertex[y] = vv.id;
            times[y] = _times[vv.id];
            //cout << "tree time of " << y << " is " << times[y] << " of id " << vv.id << endl;
        }
        //for (int i = 1; i <= N; i++) if (exist[i]) cout << "time od " << i << " je " << times[i] << endl;
        for (int i = 1; i <= N; i++) if (exist[i]) maxt[0][i] = times[i];
        for (int i = 1; i <= N; i++) if (exist[i]) revtimes[times[i]] = i;//, cout << "revtimes[" << times[i] << "] = " << i << endl;
        makecales();
        //cout << "pravi se lca" << endl;
        lt = new lcatree(edges, N+1, root);
    }
    void dfsmakelevel(int v, int p, int lvl) {
        level[v] = lvl;
        for (int e: edges[v]) if (e != p) dfsmakelevel(e, v, lvl+1);
    }
    void dfsmakecale(int v, int p) {
        cale[0][v] = p;
        for (int e: edges[v]) if (e != p) dfsmakecale(e, v);
    }
    void makecales() {
        // dfsmakecale(root, -1);
        int h = 1;
        for (int lv = 1; lv < 20; lv++) {
            h *= 2;
            for (int i: real) {
                if (h > level[i] + 1) continue;
                int daddy = cale[i][lv-1];
                cale[lv][i] = cale[lv-1][daddy];
                maxt[lv][i] = max(maxt[lv-1][i], maxt[lv-1][daddy]);
            }
        }
    }
    int msb(int i) {
        int nivo = 0;
        while (i >>= 1) nivo++;
        return nivo;
    }
    vector<int> stepeni(int num) {
        vector<int> ret;
        stepeni2(num, ret);
        //cout << "{stepeni od " << num << " su: ";
        //for (int e: ret) cout << e << ", ";
        //cout << "} ";
        return ret;
    }
    void stepeni2(int num, vector<int>& ret) {
        if (num == 0) return;
        int nivo = msb(num);
        int val = 1 << nivo;
        ret.push_back(nivo);
        stepeni2(num - val, ret);
    }
    int maxtl(int v, int lvl) {
        int ans = -1;
        vector<int> skokovi = stepeni(lvl);
        for (int skok: skokovi) {
            //cout << "{" << "skacem " << skok << " od " << v << " na ";
            int maxtt = maxt[skok][v];
            ans = max(ans, maxtt);
            v = cale[skok][v];
            //cout << v << "} ";
        }
        return ans;
    }
    int lastedge(int a, int b) {
        int calos = lt->lca(a, b);
        //cout << "{calos od " << a << " i " << b << " je " << calos << " {} ";
        int alvl = level[a], blvl = level[b], clvl = level[calos];
        int jumpa = level[a] - level[calos], jumpb = level[b] - level[calos];
        //cout << "jumpa: " << jumpa << " jumpb: " << jumpb << " {} ";
        int maxta = maxtl(a, jumpa), maxtb = maxtl(b, jumpb);
        //cout << "maxta: " << maxta << " maxtb: " << maxtb << "}";
        int maxxt = max(maxta, maxtb);
        return eidfromvertex[revtimes[maxxt]];
    }
};

vector<int> NadjiPoredak(int N, int M, int* X, int* Y, int* W) {
    vector<veza> ed;
    for (int i = 1; i <= M; i++) ed.push_back(veza{W[i], X[i], Y[i], i});
    sort(ed.begin(), ed.end());
    int timec = 0;
    int times[M+1];
    int root = -1;
    vector<veza> iqed;
    repopulisi(N);
    vector<veza> unused;
    vector<int> usedids;
    int cost[M+1];
    for (veza e: ed) {
        if (!porodica(e.x, e.y)) {
            //cout << "ujedninjavam " << e.x << " i " << e.y  << " sa id " << e.id << endl;
            ujedini(e.x, e.y);
            iqed.push_back(e);
            times[e.id] = M-(timec++);
            //cout << "set times[" << e.id << "] = " << times[e.id] << endl;
            usedids.push_back(e.id);
            root = e.x;
        } else unused.push_back(e);
    }
    reverse(usedids.begin(), usedids.end());
    //cout << "karam drvo" << endl;
    Tree drvo(N, M, iqed, times);
    //cout << "napravio" << endl;
    vector<int> addp[M+1];
    for (veza e: unused) {
        addp[drvo.lastedge(e.x, e.y)].push_back(e.id);
        //cout << "[" << e.x << ", " << e.y << "] se prvi put pojavljuje posle " << drvo.lastedge(e.x, e.y) << "-tog edga" << endl;
    }

    vector<int> sol;
    for (int e: usedids) {
        sol.push_back(W[e]);
        vector<int> novi;
        for (int e: addp[e]) novi.push_back(W[e]);
        sort(novi.begin(), novi.end());
        reverse(novi.begin(), novi.end());
        for (int e: novi) sol.push_back(e);
    }
    return sol;
}