#include <bits/stdc++.h>
#define bitcnt(x) (__builtin_popcountll(x))
#define lg(x) (63 - __builtin_clzll(x))
#define highpow(x) (1LL<<lg(x))

using namespace std;

const int INF = 2e9;

class segtree{

    int n;
    vector<int> tree;

    void init(int s){
        n = highpow(s);
        if (bitcnt(s)>1) n <<= 1;
        tree.assign(2*n, INF);
    }

    int update(int s, int l, int r, int pos, int x){
        if (l > pos || r < pos) return tree[s];
        if (l == r) return tree[s] = x;
        int m = (l + r)>>1;
        int a = update(2*s, l, m, pos, x);
        int b = update(2*s+1, m+1, r, pos, x);
        return tree[s] = min(a, b);
    }

    int query(int s, int l, int r, int ql, int qr) const {
        if (l > qr || r < ql) return INF;
        if (l >= ql && r <= qr) return tree[s];
        int m = (l + r)>>1;
        int a = query(2*s, l, m, ql, qr);
        int b = query(2*s+1, m+1, r, ql, qr);
        return min(a, b);
    }

public:
    segtree(int n){ init(n); }
    void update(int pos, int x){ update(1, 0, n-1, pos, x); }
    int query(int l, int r) const { return query(1, 0, n-1, l, r); }
};

void Trening(int n, int* t, int q, int* x, int* y, int* z, int* Ans){

    segtree st1(n), st2(n);
    for (int i = 1; i <= n; i++){
        st1.update(i, t[i] - 2*(i-1));
        st2.update(i, t[i] - 2*(n-i));
    }
    for (int i = 1; i <= q; i++){
        if (x[i] == 1){
            st1.update(y[i], z[i] - 2*(y[i]-1));
            st2.update(y[i], z[i] - 2*(n-y[i]));
        }
        else{
            int a = st1.query(y[i], z[i]) + 2*(y[i]-1);
            int b = st2.query(y[i], z[i]) + 2*(n-z[i]);
            Ans[i] = (a >= 0 && b >= 0);
        }
    }
}