#include <bits/stdc++.h>
using namespace std;

const int N = 200000;

struct Segment{
    int seg[4*N+5];
    void upd_min(int node, int l, int r, int x, int val){
        if(l == r){
            seg[node] = val;
            return;
        }
        int mid = (l+r)/2;
        if(x <= mid) upd_min(node*2, l, mid, x, val);
        else upd_min(node*2+1, mid+1, r, x, val);
        seg[node] = min(seg[node*2], seg[node*2+1]);
    }
    void upd_max(int node, int l, int r, int x, int val){
        if(l == r){
            seg[node] = val;
            return;
        }
        int mid = (l+r)/2;
        if(x <= mid) upd_max(node*2, l, mid, x, val);
        else upd_max(node*2+1, mid+1, r, x, val);
        seg[node] = max(seg[node*2], seg[node*2+1]);
    }
    int query_min(int node, int l, int r, int tl, int tr){
        if(tl > r || l > tr) return N + 5;
        if(tl <= l && r <= tr) return seg[node];
        int mid = (l+r)/2;
        return min(query_min(node*2, l, mid, tl, tr), query_min(node*2+1, mid+1, r, tl, tr));
    }
    int query_max(int node, int l, int r, int tl, int tr){
        if(tl > r || l > tr) return 0;
        if(tl <= l && r <= tr) return seg[node];
        int mid = (l+r)/2;
        return max(query_max(node*2, l, mid, tl, tr), query_max(node*2+1, mid+1, r, tl, tr));
    }
} seg_left, seg_right;

void Trening(int n, int* t, int q, int* x, int* y, int* z, int* Ans){
    for(int i=1; i<=4*n; i++){
        seg_left.seg[i] = n + 5;
        seg_right.seg[i] = -1;
    }
    for(int i=1; i<=n; i++){
        int d = t[i]/2;
        int dl = max(1, i - d);
        seg_left.upd_max(1, 1, n, i, dl);
        int dr = min(n, i + d);
        seg_right.upd_min(1, 1, n, i, dr);
    }
    for(int i=1;i<=q;i++){
        if(x[i]==1){
            int id = y[i];
            t[id] = z[i];
            int d = t[id]/2;
            int dl = max(1, id - d);
            seg_left.upd_max(1, 1, n, id, dl);
            int dr = min(n, id + d);
            seg_right.upd_min(1, 1, n, id, dr);
        }
        else{
            int l = y[i], r = z[i];
            int dl = seg_left.query_max(1, 1, n, l, r);
            int dr = seg_right.query_min(1, 1, n, l, r);
            if(dl <= l && r <= dr) Ans[i] = 1;
            else Ans[i] = 0;
        }
    }
}

/*
5 5
4 5 6 2 3
2 1 5
2 1 3
2 4 5
1 3 2
2 1 3
*/