#include <vector>

using namespace::std;

vector<vector<int>> graph;
vector<bool> visited;
int mxbr = 0;

void dfs(int node, int br = 0) {
    visited[node] = true;
    for(auto i : graph[node]) {
        if(visited[i]) continue;
        dfs(i, br + 1);
    }
    visited[node] = false;
    mxbr = max(br, mxbr);
}

int dfs2(int node, bool st = false) {
    visited[node] = true;
    int mx1 = 0, mx2 = 0;
    for(auto i : graph[node]) {
        if(visited[i]) continue;
        int pom = dfs2(i) + 1;
        if(pom >= mx1) {
            mx2 = mx1;
            mx1 = pom;
        } else if(pom > mx2) mx2 = pom;
    }
    mxbr = max(mx1 + mx2, mxbr);
    if(st) return mx1 + mx2;
    return mx1;
}

int NajduziPut(int N, int M, int* U, int* V)
{
    graph.resize(N);
    visited.assign(N, false);
    for(int i=1;i<=M;i++) {
        graph[U[i] - 1].push_back(V[i] - 1);
        graph[V[i] - 1].push_back(U[i] - 1);
    }
    if(N <= 1) {
        for(int i=0;i<N;i++) {
            visited.assign(N, false);
            dfs(i);
        }
    }
    else {
        return max(dfs2(0, true), mxbr);
    }
    return mxbr;
}