#include <bits/stdc++.h>
#define MAXN 200010
using namespace std;
struct element
{
    int levo,desno;
};
element Racunaj(int poz,int vr,int N)
{
    int l=max(1,poz-vr/2),r=min(N,poz+vr/2);
    return {l,r};
}
int s;
struct seg_tree
{
    vector<element> v;
    element neutral_element={INT_MIN,INT_MAX};
    element Merge(element a,element b)
    {
        return {max(a.levo,b.levo),min(a.desno,b.desno)};
    }
    void Init(int N)
    {
        s=1;
        while (s<=N)
            s <<= 1;
        v.resize(2*s,neutral_element);
    }
    void Build(int* T,int N)
    {
        for (int i=s;i<s+N;i++)
        {
            element r=Racunaj(i-s+1,T[i-s+1],N);
            v[i]=r;
        }
        for (int i=s-1;i>0;i--)
            v[i]=Merge(v[i*2],v[i*2+1]);
    }
    void Add(int l,int r,int vr,int x,int lx,int rx,int N)
    {
        if (lx>r || rx<l)
            return;
        if (rx-lx==0)
        {
            v[x]=Racunaj(l,vr,N);
            return;
        }
        int mid=(lx+rx)/2;
        Add(l,r,vr,2*x,lx,mid,N);
        Add(l,r,vr,2*x+1,mid+1,rx,N);
        v[x]=Merge(v[2*x],v[2*x+1]);
        return;
    }
    element Calc(int l,int r,int x,int lx,int rx)
    {
        if (lx>r || rx<l)
            return neutral_element;
        if (lx>=l && rx<=r)
            return v[x];
        int mid=(lx+rx)/2;
        element c1=Calc(l,r,2*x,lx,mid),c2=Calc(l,r,2*x+1,mid+1,rx);
        return Merge(c1,c2);
    }
};
void Trening(int N, int* T, int Q, int* X, int* Y, int* Z, int* Ans)
{
    seg_tree S;
    S.Init(N);
    S.Build(T,N);
    for (int i=1;i<=Q;i++)
    {
        if (X[i]==1)
        {
            S.Add(Y[i],Y[i],Z[i],1,1,s,N);
            continue;
        }
        element t=S.Calc(Y[i],Z[i],1,1,s);
        if (t.levo>t.desno)
        {
            Ans[i]=0;
            continue;
        }
        if (t.levo<=Y[i] && t.desno>=Z[i])
        {
            Ans[i]=1;
            continue;
        }
        Ans[i]=0;
    }
}