#include <unordered_map>
#include <map>
#include <vector>
#include <limits>
#include <algorithm>
#include <queue>
#include <stack>
#include <iostream>

using namespace std;

int res = 0;
std::unordered_map<int, int> seen;

int dfs(std::vector<std::vector<int>> a, int i, int r) {
    if (seen[i]) return seen[i];
    std::vector<int> v = a[i];
    a[i].clear();
    int cmax = 0;
    for (int j = 0; j < v.size(); j++) {
        if (a[v[j]].size() != 0) {
            int k = dfs(a, v[j], r+1);
            if (k > cmax) {
                cmax = k;
            }
        }
    }
    if (cmax == 0) return r;
    return seen[i] = cmax;
}

int bfs(std::vector<std::vector<int>> a, int i) {
    std::queue<std::pair<std::vector<int>, int>> q;
    q.push({a[i], 0});
    a[i].clear();
    int m = 0;
    while (!q.empty()) {
        std::vector<int> v = q.front().first;
        int t = q.front().second;
        m = t;
        q.pop();
        for (int j = 0; j < v.size(); j++) {
            if (a[v[j]].size() != 0) {
                q.push({a[v[j]], t + 1});
                a[v[j]].clear();
            }
        }
    }
    return m;
}

int NajduziPut(int N, int M, int* U, int* V) {
    std::vector<std::vector<int>> a(N+1, std::vector<int>());
    for (int i = 1; i <= M; i++) {
        a[U[i]].push_back(V[i]);
        a[V[i]].push_back(U[i]);
    }
    for (int i = 1; i <= N; i++) {
        int o = bfs(a, i);
        if (o > res) res = o;
    }
    return res;
}