#include <bits/stdc++.h>

#define pb push_back
#define MAXN 200010

using namespace std;

vector<int> graph[MAXN], tree[MAXN];
vector<int> dist(MAXN, -1);

void dfs(int u) {

    for(int v: tree[u]) {
        if(dist[v] == -1) {
            dist[v] = dist[u] + 1;
            dfs(v);
        }
    }
}

void make_tree(int u) {

    for(int v: graph[u]) {
        if(dist[v] == -1) {
            dist[v] = dist[u] + 1;
            tree[u].pb(v);
            tree[v].pb(u);
            make_tree(v);
        }
    }
}

int fnd(int N) {

    dist = vector<int>(N, -1);
    dist[1] = 0;
    dfs(1);

    int ans = 1;
    for(int i = 2; i <= N; i++)
        if(dist[i] > dist[ans])
            ans = i;

    dist = vector<int>(N, -1);
    dist[ans] = 0;
    dfs(ans);

    ans = 0;
    for(int i = 2; i <= N; i++)
        if(dist[i] > ans)
            ans = dist[i];
    return ans;
}

int NajduziPut(int N, int M, int* U, int* V) {

    for(int i = 1; i <= M; i++) {
        graph[U[i]].pb(V[i]);
        graph[V[i]].pb(U[i]);
    }

    if(M == N - 1) {
        make_tree(1);
        return fnd(N);
    }

    int ans = 0;
    for(int i = 1; i <= N; i++) {
        for(int j = 1; j <= N; j++)
            tree[j].clear();
        dist = vector<int>(N, -1);
        dist[i] = 0;
        make_tree(i);

        ans = max(ans, fnd(N));
    }
    return ans;
}