#include <bits/stdc++.h>
using namespace std;

#define bottom 262144

int levo[bottom * 2], desno[bottom * 2];

int constructLevo(int node, int l, int r)
{
    if(l != r){
        int mid = (l + r) / 2;
        levo[node] = max(constructLevo(node * 2, l, mid), constructLevo(node * 2 + 1, mid + 1, r));
    }

    return levo[node];
}

int constructDesno(int node, int l, int r)
{
    if(l != r){
        int mid = (l + r) / 2;
        desno[node] = min(constructDesno(node * 2, l, mid), constructDesno(node * 2 + 1, mid + 1, r));
    }

    return desno[node];
}

void update(int node)
{
    if(node < 1){return;}

    levo[node] = max(levo[node * 2], levo[node * 2 + 1]);
    desno[node] = min(desno[node * 2], desno[node * 2 + 1]);

    update(node / 2);
}

int findMax(int node, int l1, int r1, int l2, int r2)
{
    if(r1 < l2 || l1 > r2){
        return -1;
    }
    else if(l1 >= l2 && r1 <= r2){
        return levo[node];
    }
    else{
        int mid = (l1 + r1) / 2;
        return max(findMax(node * 2, l1, mid, l2, r2), findMax(node * 2 + 1, mid + 1, r1, l2, r2));
    }
}

int findMin(int node, int l1, int r1, int l2, int r2)
{
    if(r1 < l2 || l1 > r2){
        return 200005;
    }
    else if(l1 >= l2 && r1 <= r2){
        return desno[node];
    }
    else{
        int mid = (l1 + r1) / 2;
        return min(findMin(node * 2, l1, mid, l2, r2), findMin(node * 2 + 1, mid + 1, r1, l2, r2));
    }
}

void Trening(int n, int* t, int q, int* x, int* y, int* z, int* Ans){
    for(int i = 1; i <= bottom; ++i){
        levo[bottom + i - 1] = -1;
        desno[bottom + i - 1] = 200005;
    }

    for(int i = 1; i <= n; ++i){
        levo[bottom + i - 1] = max(i - t[i] / 2, 1);
        desno[bottom + i - 1] = min(i + t[i] / 2, n);
    }

    constructLevo(1, 1, bottom);
    constructDesno(1, 1, bottom);

    for(int i = 1; i <= q; ++i){
        if(x[i] == 1){
            int node = bottom + y[i] - 1;

            levo[node] = max(y[i] - z[i] / 2, 1);
            desno[node] = min(y[i] + z[i] / 2, n);

            update(node / 2);
        }
        else{
            int valLevo = findMax(1, 1, bottom, y[i], z[i]);
            int valDesno = findMin(1, 1, bottom, y[i], z[i]);

            if(valLevo <= y[i] && valDesno >= z[i]){Ans[i] = 1;}
            else{Ans[i] = 0;}
        }
    }
}