#include <bits/stdc++.h>

using namespace std;

struct ne_znam_kako_da_te_nazovem {
	int val;
	bool closing;
	int index;
};

struct Query {
	int l;
	int r;
	int x;
};

const int N = 2e5 + 10;
int n, q;
ne_znam_kako_da_te_nazovem a[2 * N];
int st[4 * N];
Query Q[N];
int order[N];
int ans[N];

void update(int index, int l, int r, int x, int val) {
	if(l > r || r < x || x < l) return;
	if(l == r) {
		st[index] += val;
		return;
	}
	int mid = (l + r) >> 1;
	update(2 * index + 1, l, mid, x, val);
	update(2 * index + 2, mid + 1, r, x, val);
	st[index] = st[2 * index + 1] + st[2 * index + 2];
}

int get(int index, int l, int r, int L, int R) {
	if(l > r || R < l || r < L) return 0;
	if(L <= l && r <= R) return st[index];
	int mid = (l + r) >> 1;
	return get(2 * index + 1, l, mid, L, R) + get(2 * index + 2, mid + 1, r, L, R);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n >> q;
    for(int i = 0; i < n; i++) {
    	cin >> a[2 * i].val >> a[2 * i + 1].val;
    	a[2 * i].val--;
    	a[2 * i].closing = false;
    	a[2 * i + 1].closing = true;
    	a[2 * i].index = a[2 * i + 1].index = i;
    }
    for(int i = 0; i < q; i++) {
    	cin >> Q[i].l >> Q[i].r >> Q[i].x;
    	Q[i].l--;
    	Q[i].r--;
    }
    sort(a, a + 2 * n, [&](ne_znam_kako_da_te_nazovem i, ne_znam_kako_da_te_nazovem j) {
    	if(i.val == j.val) return i.closing < j.closing;
    	return i.val < j.val;
    });
	iota(order, order + q, 0);
	sort(order, order + q, [&](int i, int j) { return Q[i].x < Q[j].x; });
	int cnt = 0;
	for(int i = 0; i < q; i++) {
		while(cnt < 2 * n && a[cnt].val < Q[order[i]].x) {
			if(!a[cnt].closing) update(0, 0, n - 1, a[cnt].index, 1);
			else update(0, 0, n - 1, a[cnt].index, -1);
			cnt++;
		}
		ans[order[i]] = get(0, 0, n - 1, Q[order[i]].l, Q[order[i]].r);
	}
	for(int i = 0; i < q; i++) cout << ans[i] << "\n";
    return 0;
}