#include <bits/stdc++.h>
using namespace std;
#define INF 0x3f3f3f3f
 

typedef pair<int, int> intPair;
 
class Graf {
    int V;
 
    list<pair<int, int> >* adj;
 
public:
    Graf(int V);
 
    void dodajVezu(int u, int v, int w);
 
    long najkraciPut(int poc, int kraj);
};
 
Graf::Graf(int V)
{
    this->V = V;
    adj = new list<intPair>[V];
}
 
void Graf::dodajVezu(int u, int v, int w)
{
    adj[u].push_back(make_pair(v, w));
    adj[v].push_back(make_pair(u, w));
}
 
long Graf::najkraciPut(int poc, int kraj)
{
    priority_queue<intPair, vector<intPair>, greater<intPair> >
        pq;
 
    vector<int> dist(V, INF);
 
    pq.push(make_pair(0, poc));
    dist[poc] = 0;
 

    while (pq.empty() == false) {

        int u = pq.top().second;
        pq.pop();
 
 		list<pair<int, int> >::iterator i;

        for (i = adj[u].begin(); i != adj[u].end(); ++i) {
            int v = (*i).first;
            int weight = (*i).second;
 
            if (dist[v] > dist[u] + weight) {
            	
                dist[v] = dist[u] + weight;
                pq.push(make_pair(dist[v], v));
            }
        }
    }
 

    int rezultat=2*dist[kraj];
	
	return rezultat;
}
 
int main()
{
	int N, M, V, U;
	cin>>N>>M;
	
	Graf g(N+1);
	
	int a, b, t;
	for(int i=0; i<M; i++){
		cin>>a>>b>>t;
		g.dodajVezu(a, b, t);
	}
	
 	
	cin>>V>>U;
 
    cout<< g.najkraciPut(V, U);
 
    return 0;
}