#include <bits/stdc++.h>
using namespace std;

const int INF = 2000000000;

const int MAXN = 200002;
vector<pair<int, int>> t[4 * MAXN];
 
vector<pair<int, int>> combine(vector<pair<int, int>> a, vector<pair<int, int>> b) {
    vector<pair<int, int>> c;
    c.reserve(a.size() + b.size());
    std::merge(a.begin(), a.end(),
           b.begin(), b.end(),
           std::back_inserter(c));
    return c;
}

void build(vector<pair<int, int>>& vec, int v, int tl, int tr) {
    if (tl == tr) {
        t[v] =  {vec[tl]};
    } else {
        int tm = (tl + tr) / 2;
        build(vec, v*2, tl, tm);
        build(vec, v*2+1, tm+1, tr);
        t[v] = combine(t[v*2], t[v*2+1]);
    }
}

vector<pair<int, int>> get(int v, int tl, int tr, int l, int r) {
    if (l > r) return {};
    if (l == tl && r == tr)
        return t[v];
    int tm = (tl + tr) / 2;

    return combine(get(v*2, tl, tm, l, min(r, tm)), 
                   get(v*2+1, tm+1, tr, max(l, tm+1), r));
}


int main(int argc, char **argv){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> vec(n+1);
    for(int i = 1; i <= n; i++) {
    	int d, u;
    	cin >> d >> u;

    	vec[i] = {d, u};
    }

    build(vec, 1, 1, n);
    for(int i = 0; i <= 2 * n - 1; i++){
        //cout << t[i].first << " " << t[i].second << endl;
    }

    for(int i = 0; i < m; i++){
        int lu, du, x;
        cin >> lu >> du >> x;
        auto v = get(1, 1, n, lu, du);
        int l = 0, r = v.size() - 1;

        //for(auto uv : v) {
        //    cout << uv.first << " " << uv.second << endl;
        //}

        int ans = 0;
        int index = -1;
        while(l <= r) {
            int mid = (l + r)/2;
            if(x >= v[mid].first) {
                index = mid;
                r = mid - 1;
            }
            else{
                l = mid + 1;
            }
        }
        //cout << index << endl;
        if(index == -1) {
            cout << 0 << endl;
            continue;
        }

        for(int i = index; i < v.size(); i++) {
            if(v[i].first > x) break;
            if(v[i].second >= x) {
                ans++;
                //cout << v[i].first << " " << v[i].second << endl;
            }
        }


        cout << ans << endl;
    }
    
    return 0;
}