#include <bits/stdc++.h>
#define ll long long
#define MAXN 200010
using namespace std;
ll n,s,d[MAXN],u[MAXN];
struct seg_tree
{
    vector<vector<ll> > st;
    vector<ll> neutral;
    vector<ll> Merge(vector<ll> a,vector<ll> b)
    {
        vector<ll> c;
        ll posa=0,posb=0;
        while (posa<a.size() && posb<b.size())
        {
            if (a[posa]<b[posb])
            {
                c.push_back(a[posa]);
                posa++;
            }
            else
            {
                c.push_back(b[posb]);
                posb++;
            }
        }
        while (posa<a.size())
        {
            c.push_back(a[posa]);
            posa++;
        }
        while (posb<b.size())
        {
            c.push_back(b[posb]);
            posb++;
        }
        return c;
    }
    void Init()
    {
        s=1;
        while (s<n)
            s <<= 1;
        st.resize(2*s,neutral);
    }
    void Build_L()
    {
        for (ll i=s;i<s+n;i++)
            st[i]={d[i-s+1]};
        for (ll i=s-1;i>=0;i--)
            st[i]=Merge(st[2*i],st[2*i+1]);
    }
    void Build_R()
    {
        for (ll i=s;i<s+n;i++)
            st[i]={u[i-s+1]};
        for (ll i=s-1;i>=0;i--)
            st[i]=Merge(st[2*i],st[2*i+1]);
    }
    ll Calc(ll l,ll r,ll val,ll x,ll lx,ll rx)
    {
        if (lx>=l && rx<=r)
        {
            auto it=lower_bound(st[x].begin(),st[x].end(),val);
            if ((*it)>val || it==st[x].end())
                it--;
            return it-st[x].begin()+1;
        }
        if (lx>r || rx<l)
            return 0;
        ll mid=(lx+rx)/2;
        return Calc(l,r,val,2*x,lx,mid)+Calc(l,r,val,2*x+1,mid+1,rx);
    }
};
seg_tree L,R;
int main()
{
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    ll m,l,r,x;
    cin >> n >> m;
    for (ll i=1;i<=n;i++)
        cin >> d[i] >> u[i];
    L.Init();
    L.Build_L();
    R.Init();
    R.Build_R();
    while (m--)
    {
        cin >> l >> r >> x;
        ll a=L.Calc(l,r,x,1,1,s);
        ll b=R.Calc(l,r,x-1,1,1,s);
        cout << a-b << "\n";
    }
    return 0;
}