using System;

namespace Sante
{
    internal class Program
    {
        public struct Put {
            public long pocetak;
            public long destinacija;
            public int tip;
        }

        static void Main(string[] args)
        {
            long[] row1 = getUnos();
            
            long brojSanti = row1[0];
            long brojPuteva = row1[1];

            Put[] putevi = new Put[brojPuteva];

            for(int i = 0; i < brojPuteva; i++) {    
                long[] input = getUnos();

                putevi[i].pocetak = input[0];
                putevi[i].destinacija = input[1];
                putevi[i].tip = (int)input[2];
            }

            long[] end = getUnos();
            
            long start = end[0];
            long dest = end[1];

            long[] routes = new long[brojPuteva];
            long j = 0;
            for(int i = 0; i < brojPuteva; i++) {
                if(putevi[i].pocetak == start) {
                    long res = explore(putevi, 0, 0, i, dest);
                    if(res > -1) {
                        routes[j] = res;
                        j++;
                    }
                }
            }

            long min = long.MaxValue;
            for(long i = 0; i < j; i++) {
                if(routes[i] < min) {
                    min = routes[i];
                }
            }

            System.Console.WriteLine(min);
        }

        static long explore(Put[] putevi, int stanje, long brojac, long put, long dest) {
            if(putevi[put].tip != stanje) {
                brojac++;
                stanje = putevi[put].tip;
            } 
            if(putevi[put].destinacija == dest) {
                return brojac;
            }
            for(int i = 0; i < putevi.Length; i++) {
                if(putevi[i].pocetak == putevi[put].destinacija) {
                    return explore(putevi, stanje, brojac, i, dest);
                }
            }
            return -1;
        }

        static long[] getUnos() {
            return Console
                .ReadLine()
                .Split(new Char[] {' '}, StringSplitOptions.RemoveEmptyEntries)
                .Select(item => long.Parse(item))
                .ToArray();
        }
    }
}