#include <bits/stdc++.h>

using namespace std;

int from, to;

bool hasPath(vector<vector<int>> data, int point){
	return data[point].size() > 5;
}

bool exists(vector<vector<int>> data, int point){
	return data[point].size() > 0;
}

bool hasData(vector<vector<int>> data, int point){
	return exists(data, point) && data[point][0] >= 0;
}

void run(vector<vector<int>>& data, int n){
	int _v1 = -1, _v2 = -1, _v3 = -1, _v4 = -1;
	data[n][4] = 1;

	
	for(int i = 5; i < data[n].size(); i++){
		int v1 = 99999, v2 = 99999, v3 = 99999, v4 = 99999;
		
		int pathTo = data[n][i];
		int actualPath = abs(pathTo);
		bool pos = pathTo >= 0;
		
		if(data[actualPath][4] == 1) continue;
		if(!hasData(data, actualPath)) run(data, actualPath);
		
		if(actualPath == to){
			if(pos){
				v1 = 0; v2 = 1; v3 = 0; v4 = 0;
			}else{
				v1 = 1; v2 = 0; v3 = 1; v4 = 1;
			}
		}else {
			int d1 = data[actualPath][0];
			int d2 = data[actualPath][1];
			int d3 = data[actualPath][2];
			int d4 = data[actualPath][3];
			
			if(pos){
				if(d4 == 1) d2 = d1 + 1;
				
				d3 = 0;
				d4 = 0;
			}else{
				if(d3 == 0) d1 = d2 + 1;
				
				d3 = 1;
				d4 = 1;
			}
			v1 = d1; v2 = d2; v3 = d3; v4 = d4;
		}
		
		if(v1 < _v1 || _v1 == -1) {
			_v1 = v1;
			_v3 = v3;
		}
		
		if(v2 < _v2 || _v2 == -1) {
			_v2 = v2;
			_v4 = v4;
		}
		
	}
	
	data[n][0] = _v1;
	data[n][1] = _v2;
	data[n][2] = _v3;
	data[n][3] = _v4;
	
	data[n][4] = 0;
}

int main() {
	ios::sync_with_stdio(false); cin.tie(0);
	int N, M;
	cin>>N>>M;

	vector<vector<int>> data(N+1);
	
	for(int i = 0; i < M; i++){
		int a, b, t;
		cin>>a>>b>>t;
		
		
		if(data[a].size() == 0) {
			data[a].push_back(-1);
			data[a].push_back(-1);
			data[a].push_back(-1);
			data[a].push_back(-1);
			data[a].push_back(0);
		}
		
		if(data[b].size() == 0) {
			data[b].push_back(-1);
			data[b].push_back(-1);
			data[b].push_back(-1);
			data[b].push_back(-1);
			data[b].push_back(0);
		}
		
		int _a = a, _b = b;
		if(t == 1) {
			_a *= -1;
			_b *= -1;
		}
		
		if(count(data[a].begin() + 5, data[a].end(), _b)) continue;
		if(count(data[b].begin() + 5, data[b].end(), _a)) continue;
		
		data[a].push_back(_b);
		data[b].push_back(_a);
	}
	
	cin>>from>>to;
	
	run(data, from);
	
	cout<<data[from][0];
	
	return 0;
}