using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sante
{
    class Program
    {
        struct Veza
        {
            public int povezan, tip;

            public Veza(int povezan, int tip)
            {
                this.povezan = povezan;
                this.tip = tip;
            }
        }

        static Veza taVeza (List<Veza>[] veze, int a, int b)
        {
            foreach (Veza x in veze[a])
            {
                if (x.povezan == b) return x;
            }

            return new Veza(0, 0);
        } 

        static bool dfs(int r1, int r2, bool[] posecen, List<Veza>[] veze, ref int prelazi, int prosloStanje)
        {
            if (r1 == r2)
            {
                if (taVeza(veze, r1, r2).tip != prosloStanje)
                {
                    prelazi++;
                    prosloStanje = taVeza(veze, r1, r2).tip;
                }
                return true;
            }
            if (posecen[r1])
                return false;
            posecen[r1] = true;
            foreach (Veza r in veze[r1])
            {
                if (taVeza(veze, r.povezan, r2).tip != prosloStanje)
                {
                    prelazi++;
                    prosloStanje = taVeza(veze, r1, r2).tip;
                }
                if (dfs(r.povezan, r2, posecen, veze, ref prelazi, prosloStanje))
                    return true;
            }
            return false;
        }

        static bool povezani(int r1, int r2, int brojCvorova, List<Veza>[] veze, ref int prelazi)
        {
            bool[] posecen = new bool[brojCvorova];
            return dfs(r1, r2, posecen, veze, ref prelazi, 0);
        }


        static void Main(string[] args)
        {
            int sante, putevi, prelazi = 0;
            string[] unos;
            List<Veza>[] veze; 

            unos = Console.ReadLine().Split();

            sante = int.Parse(unos[0]);
            putevi = int.Parse(unos[1]);
            veze = new List<Veza>[putevi];

            for (int i = 0; i < putevi; i++) veze[i] = new List<Veza>();

            for (int i = 0; i < putevi; i++)
            {
                unos = Console.ReadLine().Split();
                veze[int.Parse(unos[0]) - 1].Add(new Veza(int.Parse(unos[1]) - 1, int.Parse(unos[2])));
            }

            unos = Console.ReadLine().Split();

            if (!povezani(int.Parse(unos[0]), int.Parse(unos[1]), sante, veze, ref prelazi)) Console.WriteLine(-1);
            else Console.WriteLine(prelazi);
            Console.ReadKey();
        }
    }
}