#include <bits/stdc++.h>

using namespace std;

struct node{
    int l, r, val, ind;
};

int main(){

    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, m;

    cin >> n >> m;

    vector<node> lbQ(n+m+1), ubQ(n+m+1);
    lbQ[0].val = INT_MIN, ubQ[0].val = INT_MIN;

    for(int i = 1; i <= n; ++i){
        cin >> lbQ[i].val >> ubQ[i].val;

        lbQ[i].ind = i, ubQ[i].ind = i;
        lbQ[i].l = -1, ubQ[i].l = -1;
        lbQ[i].r = -1, ubQ[i].r = -1;
    }

    for(int i = n+1; i <= n+m; ++i){
        cin >> lbQ[i].l >> lbQ[i].r >> lbQ[i].val;
        
        ubQ[i].l = lbQ[i].l;
        ubQ[i].r = lbQ[i].r;
        ubQ[i].val = lbQ[i].val;
        lbQ[i].ind = i-n, ubQ[i].ind = i-n;
    }

    sort(lbQ.begin() + 1, lbQ.end(), [](const node& n1, const node& n2){
        if(n1.val == n2.val) return n1.l > n2.l;

        return n1.val > n2.val;
    });

    sort(ubQ.begin() + 1, ubQ.end(), [](const node& n1, const node& n2){
        if(n1.val == n2.val) return n1.l < n2.l;

        return n1.val > n2.val;
    });

    auto update = [](vector<int>& fw, int n, int ind){
        while(ind <= n){
            ++fw[ind];

            ind += ind & (-ind);
        }
    };

    auto query = [](vector<int>& fw, int ind){
        int ans = 0;

        while(ind > 0){
            ans += fw[ind];
            ind -= ind & (-ind);
        }

        return ans;
    };

    vector<int> lbFw(n+1), ubFw(n+1);
    vector<int> ans(m+1);

    for(int i = 1; i <= n+m; ++i){
        if(ubQ[i].l == -1) update(ubFw, n, ubQ[i].ind);
        else ans[ubQ[i].ind] = query(ubFw, ubQ[i].r) - query(ubFw, ubQ[i].l - 1);
    }

    for(int i = 1; i <= n+m; ++i){
        if(lbQ[i].l == -1) update(lbFw, n, lbQ[i].ind);
        else ans[lbQ[i].ind] -= query(lbFw, lbQ[i].r) - query(lbFw, lbQ[i].l - 1);
    }

    for(int i = 1; i <= m; ++i) cout << ans[i] << '\n';
    return 0;
}