#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>

struct node {
    int start;
    int end;
    int max;
    int i;
    node* left, *right;
};

node* init(int start, int end, int index) {
    node* temp = new node;
    temp->start = start;
    temp->end = end;
    temp->max = end;
    temp->i = index;
    temp->left = NULL;
    temp->right = NULL;
    return temp;
};

node* create(node* root, int start, int end, int index) {
    if (root == NULL) {
        return init(start, end, index);
    }

    if (start < root->start) {
        root->left = create(root->left, start, end, index);
    }
    else {
        root->right = create(root->right, start, end, index);
    }

    if (root->max < end) {
        root->max = end;
    }

    return root;
}

int res = 0;

void traverse(node* root, int vstart, int vend, int target) {
    if (root == NULL) {
        return;
    }

    if (root->start <= target && root->end >= target) {
        //std::cout << "pass1" << std::endl;
        if (root->i >= vstart && root->i <= vend) {
            //std::cout << "pass2" << std::endl;
            res++;
        }
    }

    if (root->left != NULL && root->left->max >= target) {
        traverse(root->left, vstart, vend, target);
    }
    if (root->right != NULL && root->right->max >= target) {
        traverse(root->right, vstart, vend, target);
    }
}

std::vector<std::vector<int>> sorted;
void advancedSort(std::vector<std::vector<int>>& a, int start, int end) {
    if (start > end) {
        return;
    }

    int mid = (start + end) / 2;
    sorted.push_back(a[mid]);

    advancedSort(a, start, mid - 1);
    advancedSort(a, mid+1, end);
}


int main() {
    //IST

    std::ios_base::sync_with_stdio(false); std::cin.tie(0);

    int n, q;
    std::cin >> n >> q;
    node* root = NULL;
    std::vector<std::vector<int>> indices;
    for (int i = 0; i < n; i++) {
        int a, b;
        std::cin >> a >> b;
        indices.push_back({ a, b, i+1 });
    }
    std::sort(indices.begin(), indices.end());
    advancedSort(indices, 0, indices.size()-1);
    indices = sorted;

    for (int i = 0; i < n; i++) {
        root = create(root, indices[i][0], indices[i][1], indices[i][2]);
    }

    for (int i = 0; i < q; i++) {
        res = 0;
        int a, b, c;
        std::cin >> a >> b >> c;
        traverse(root, a, b, c);
        std::cout << res << std::endl;
    }
}