#include <bits/stdc++.h>

using namespace std;

#define MAXS 200001
vector<vector<pair<int, int>>> adj;


bool postoji_put(int src, int dst)
{
    if(src == dst)
        return true;

    int n = (int)adj.size();

    vector<bool> visited(n, false);

    queue<int> q;

    visited[src] = true;
    q.push(src);

    while (!q.empty())
    {
        src = q.front();
        q.pop();

        for (auto x : adj[src])
        {
           if (x.first == dst)
                return true;

            if (!visited[x.first])
            {
                visited[x.first] = true;
                q.push(x.first);
            }
        }
    }

    return false;
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie();

    int n, m, a, b, t, u, v;
    bool svi_jednaki = true;

    cin >> n >> m;
    adj = vector<vector<pair<int, int>>>(n + 1);

    for (int i = 0; i < m; i++)
    {
        cin >> a >> b >> t;
        adj[a].push_back(make_pair(b, t));
        adj[b].push_back(make_pair(a, t));
        if (svi_jednaki && (t != 1))
        {
            svi_jednaki = false;
        }
    }

    cin >> u >> v;


    if (postoji_put(u, v))
    {
        if (svi_jednaki)
        {
            cout << 1 << endl;
        }
        else
        {
            cout << 0 << endl;
        }
    }
    else
    {
        cout << -1 << endl;
    }



    return 0;
}