#include <bits/stdc++.h>

using namespace std;

#define N 20

int s[N];

struct Put {
	int cilj, t;
	Put(int cilj, int t) : cilj(cilj), t(t) {}
};

class Graf {
	public:
		map<int, list<Put> > putevi;
		
		void dodaj_put(int a, int b, int t) {
			putevi[a].push_back(Put(b, t));
			putevi[b].push_back(Put(a, t));
		}
		
		void bfs(int trenutni) {
			queue<int> red;
			queue<int> stanja;
			red.push(trenutni);
			stanja.push(0);
			s[trenutni] = 0;
			int stanje = 0;
			
			while(!red.empty()) {
				stanje = stanja.front();
				stanja.pop();
				trenutni = red.front();
				red.pop();
				list<Put> susedni = putevi[trenutni];
				list<Put>::iterator itr;
				for(itr = susedni.begin(); itr != susedni.end(); itr++) {
					Put& put = *itr;
					int tezina = 0;
					int t = put.t, cilj = put.cilj;
					if(stanje != t) tezina++;
					if(s[trenutni] + tezina < s[cilj]) {
						s[cilj] = s[trenutni] + tezina;
						red.push(cilj);
						stanja.push(t);
					}
				}
			}
		}
};

int main() {
	fill_n(s, N, INT_MAX);
	int n, m;
	Graf g;
	cin>>n>>m;
	for(int i = 0; i < m; i++) {
		int a, b, t;
		cin>>a>>b>>t;
		g.dodaj_put(a, b, t);
	}
	int pocetak, kraj;
	cin>>pocetak>>kraj;
	g.bfs(pocetak);
	if(s[kraj] == INT_MAX) s[kraj] = -1;
	cout<<s[kraj];
	return 0;
}