#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

class sgmnt_tr
{
public:
	sgmnt_tr(int n);
	void upd(int position, ll new_value);
	ll sum(int l, int r);
private:
	int el_cnt;
	vector<ll> tree;
};
struct query
{int l, r;ll value;int index;};
struct ipnt
{ll value;int index;bool is_start;};

vector<int> solve(vector<pair<int,int>> ipr, vector<query> queries)
{
	int n = ipr.size();
	vector<ipnt> intervals; intervals.reserve(2 * n);
	for (int i = 0; i < n; i++)
	{
		ll l = ipr[i].first, r = ipr[i].second;
		intervals.push_back({ l,i,1 });
		intervals.push_back({ r + 1,i,0 });
	}
	int qcnt = queries.size();

	sort(intervals.begin(), intervals.end(),
		[](const ipnt& lhs, const ipnt& rhs) {
			return lhs.value < rhs.value;
	});

	sort(queries.begin(), queries.end(),
		[](const query& lhs, const query& rhs) {
			return lhs.value < rhs.value;
	});

	vector<int> sln(qcnt);

	auto tree = sgmnt_tr(n); int ind1 = 0; int ind2 = 0;
	for (int i = 0; i < intervals.size(); i++)
	{
		while (ind1 < qcnt && queries[ind1].value < intervals[i].value)
		{
			int q = queries[ind1].index, l = queries[ind1].l, r = queries[ind1].r;
			sln[q] = tree.sum(l, r + 1);
			ind1++;
		}
		if (intervals[i].is_start)
		{
			int pos = intervals[i].index;
			tree.upd(pos, 1);
		}
		else
		{
			int pos = intervals[i].index;
			tree.upd(pos, 0);
		}
	}
	while (ind1 < qcnt)
	{
		int q = queries[ind1].index, l = queries[ind1].l, r = queries[ind1].r;
		sln[q] = tree.sum(l, r);
		ind1++;
	}
	return sln;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int n, query_cnt; cin >> n >> query_cnt;
	
	vector<pair<int, int>> intervals(n);
	for (int i = 0; i < n; i++)
		cin >> intervals[i].first >> intervals[i].second;
	
	vector<query> qrs(query_cnt);
	for (int i = 0; i < query_cnt; i++)
	{
		cin >> qrs[i].l >> qrs[i].r >> qrs[i].value;
		qrs[i].l--; qrs[i].r--; qrs[i].index = i;
	}
	
	for (int x: solve(intervals, qrs))
		cout << x << "\n";
	return 0;
}

sgmnt_tr::sgmnt_tr(int n){el_cnt = n; tree = vector<ll>(el_cnt * 2);}

void sgmnt_tr::upd(int position, ll new_value)
{
	position += el_cnt;
	tree[position] = new_value;
	for (int i = position / 2; i > 0; i /= 2)
		tree[i] = tree[i * 2] + tree[i * 2 + 1];
}

ll sgmnt_tr::sum(int l, int r)
{
	l += el_cnt; r += el_cnt;
	ll sum = 0;
	while (l < r)
	{
		if (l % 2 == 1)
			sum += tree[l++];
		if (r % 2 == 1)
			sum += tree[--r];

		l /= 2; r /= 2;
	}
	return sum;
}