using System;
using System.Collections.Generic;
using System.Xml.Schema;

namespace Zad4
{
	class Program
	{
		class PocetakKraj
		{
			public bool jePocetak;
			public int vaga;
			public int vrednost;
			public static int Uporedi(PocetakKraj pk1, PocetakKraj pk2)
			{
				int c = pk1.vrednost.CompareTo(pk2.vrednost);
				if(c != 0)
				{
					return c;
				}
				if(pk1.jePocetak)
				{
					return -1;
				}
				return 1;
			}
		}
		class Segment
		{
			public int pocetak;
			public int kraj;
			public bool[] vage = null;
		}
		static int Prebroj(bool[] n, int i, int j)
		{
			int brojac = 0;
			for(int u = i; u <= j; u++)
			{
				if (n[u])
				{
					brojac++;
				}
			}
			return brojac;
		}
		static List<Segment> Segmenti(PocetakKraj[] granice)
		{
			bool[] ukljuceneVage = new bool[granice.Length / 2];
			List<Segment> segmenti = new List<Segment>();
			PocetakKraj prosli = granice[0];
			ukljuceneVage[prosli.vaga] = true;

			for(int i = 1; i < granice.Length; i++)
			{
				PocetakKraj sadasnji = granice[i];
				if(sadasnji.vrednost == prosli.vrednost && sadasnji.jePocetak == prosli.jePocetak)
				{
					continue;
				}
				Segment segment = new Segment();
				segment.vage = new bool[ukljuceneVage.Length];
				
				ukljuceneVage.CopyTo(segment.vage, 0);
				segment.pocetak = prosli.jePocetak ? prosli.vrednost : prosli.vrednost + 1;
				if (sadasnji.jePocetak)
				{
					segment.kraj = sadasnji.vrednost - 1;
					ukljuceneVage[sadasnji.vaga] = true;
				}
				else
				{
					segment.kraj = sadasnji.vrednost;
					ukljuceneVage[sadasnji.vaga] = false;
				}
				segmenti.Add(segment);
				prosli = sadasnji;
			}
			return segmenti;
		}
		static Segment NadjiSegment(int x, List<Segment> segmenti)
		{
			if(x >= segmenti[segmenti.Count - 1].pocetak)
			{
				return segmenti[segmenti.Count - 1];
			}
			int i = 0;
			int j = segmenti.Count - 1;
			int k = (segmenti.Count - 1) / 2;
			while(i != j)
			{
				if (segmenti[k].pocetak > x)
				{
					j = k;
				}
				else if(segmenti[k].kraj < x)
				{
					i = k;
				}
				else
				{
					return segmenti[k];
				}
				k = (i + j) / 2;
			}
			return segmenti[k];
		}
		static void Main()
		{
			string[] input = Console.ReadLine().Split();
			int brojVaga = int.Parse(input[0]);
			int brojPitanja = int.Parse(input[1]);
			int[,] vage = new int[brojVaga, 2];
			int[,] pitanja = new int[brojPitanja, 3];
			for (int i = 0; i < brojVaga; i++)
			{
				input = Console.ReadLine().Split();
				for (int j = 0; j < 2; j++)
				{
					vage[i, j] = int.Parse(input[j]);
				}
			}
			for (int i = 0; i < brojPitanja; i++)
			{
				input = Console.ReadLine().Split();
				for (int j = 0; j < 3; j++)
				{
					pitanja[i, j] = int.Parse(input[j]);
				}
			}
			PocetakKraj[] granice = new PocetakKraj[brojVaga * 2];
			for(int i = 0; i < brojVaga; i++)
			{
				granice[2 * i] = new PocetakKraj();
				granice[2 * i].vrednost = vage[i, 0];
				granice[2 * i].jePocetak = true;
				granice[2 * i].vaga = i;

				granice[2 * i + 1] = new PocetakKraj();
				granice[2 * i + 1].vrednost = vage[i, 1];
				granice[2 * i + 1].jePocetak = false;
				granice[2 * i + 1].vaga = i;
			}
			Array.Sort(granice, PocetakKraj.Uporedi);
			List<Segment> segmenti = Segmenti(granice);
			for(int i = 0; i < brojPitanja; i++)
			{
				Console.WriteLine(Prebroj(NadjiSegment(pitanja[i, 2], segmenti).vage, pitanja[i, 0] - 1, pitanja[i, 1] - 1));
			}
		}
	}
}