#include <iostream>
using namespace std;
struct Node {
    int index;
    int minW, maxW;
    Node* left, *right;
    int maxInSubtree;
};

Node* newNode(int index,int minW, int maxW) {
    Node* t = new Node;
    t->index = index;
    t->minW = minW;
    t->maxW = maxW;
    t->maxInSubtree = maxW;
    t->left = t->right = NULL;
    return t;
}
bool testOverlap(int rangeL, int rangeH, int value) {
    return rangeL <= value && value<=rangeH;
}
Node* insertNode(Node* root,int index,int minW,int maxW) {
    if (root == NULL)
        return newNode(index, minW, maxW);
    int l = root->minW;
    if (minW <= l)
        root->left = insertNode(root->left, index, minW, maxW);
    else
        root->right = insertNode(root->right, index, minW, maxW);
    if (root->maxInSubtree < maxW)
        root->maxInSubtree = maxW;
    return root;
}
void search(Node* root, int indexL, int indexH, int value,int* res) {
    if (root == NULL) return;
    if (root->maxInSubtree < value) return;
    if (testOverlap(root->minW, root->maxW, value))
        if(root->index>=indexL && root->index<=indexH) (*res)++;
    if (root->left != NULL && root->left->maxInSubtree >= value)
        search(root->left, indexL, indexH, value, res);
    search(root->right, indexL, indexH, value, res);
}
int main()
{
    Node* root = NULL;
    int N, Q;
    cin >> N >> Q;
    
    int min, max, i;
    int* res = new int[Q];
    int d, l, x;
    for (i = 0; i < N; i++) {
        cin >> min >> max;
        root=insertNode(root, i+1, min, max);
    }

   
    for ( i = 0; i < Q; i++) {
        cin >> d >> l >> x;
        res[i] = 0;
        search(root, d, l, x, &res[i]);
    }

    for (i = 0; i < Q; i++) {
        cout << res[i] << endl;
   }
}