#include <bits/stdc++.h>
 
using namespace std;
 
typedef long long ll;
typedef long double ld;
 
typedef vector<int> vi;
typedef vector<ll> vll;
 
typedef vector<vi> vvi;
typedef vector<vll> vvll;
 
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
 
typedef vector<pii> vpii;
typedef vector<pll> vpll;
 
typedef vector<vpii> vvpii;
typedef vector<vpll> vvpll;
 
#define pb push_back
#define mp make_pair
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define sz(x) (int)(x).size()
#define fi first
#define se second
 
template<class T> bool ckmin(T &a, const T &b) {return a > b ? a = b, 1 : 0;}
template<class T> bool ckmax(T &a, const T &b) {return a < b ? a = b, 1 : 0;}
 
namespace debug {
    void __print(int x) {cerr << x;}
    void __print(long long x) {cerr << x;}
    void __print(double x) {cerr << x;}
    void __print(long double x) {cerr << x;}
    void __print(char x) {cerr << '\'' << x << '\'';}
    void __print(const string &x) {cerr << '\"' << x << '\"';}
    void __print(const char *x) {cerr << '\"' << x << '\"';}
    void __print(bool x) {cerr << (x ? "true" : "false");}
 
    template<typename T, typename V>
    void __print(const pair<T, V> &x) {cerr << '{'; __print(x.first); cerr << ','; __print(x.second); cerr << '}';}
    template<typename T>
    void __print(const T &x) {int f = 0; cerr << '{'; for(auto z : x) cerr << (f++ ? "," : ""), __print(z); cerr << "}";}
    void _print() {cerr << "]\n";}
    template <typename T, typename... V>
    void _print(T t, V... v) {__print(t); if(sizeof...(v)) cerr << ", "; _print(v...);}
 
#ifdef DEBUG
#define dbg(x...) cerr << "\e[91m" << "LINE(" << __LINE__ << ") -> " << "[" << #x << "] = ["; _print(x); cerr << "\033[0m";
#else
#define dbg(x...)
#endif
}
 
using namespace debug;
 
const char nl = '\n';
 
mt19937 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

template<class T>
class ft {
private:
    vector<T> a;
    int n;
public:
    ft(int _n) : n(_n) {
        a.resize(n+1);
    }

    ft(const vector<T> &_a) : n((int)_a.size()) {
        a.resize(n+1);
        for(int i = 1; i <= n; ++i) {
            a[i] += _a[i-1];
            int j = i + (i&-i);
            if(j <= n) a[j] += a[i];
        }
    }

    void update(int i, T x) {
        for(; i <= n; i += i&-i) {
            a[i] += x;
        }
    }

    T query(int i) {
        T r = 0;
        for(; i; i -= i&-i) {
            r += a[i];
        }
        return r;
    }
};

struct Query {
    int l, r, x;
};

struct Query2 {
    int znak, x, i;
};

void solve() {
    int n, m;
    cin >> n >> m;

    vpii v(n + 1);

    for(int i = 1; i <= n; ++i) {
        cin >> v[i].fi >> v[i].se;
    }

    vector<Query> upiti(m + 1);

    for(int i = 1; i <= m; ++i) {
        cin >> upiti[i].l >> upiti[i].r >> upiti[i].x;
    }

    int maksVrednost = -1;

    [&]() -> void {
        vi compressed;
        compressed.reserve(2 * n + m + 2);

        for(int i = 1; i <= n; ++i) {
            compressed.pb(v[i].fi);
            compressed.pb(v[i].se);
        }

        for(int i = 1; i <= m; ++i) {
            compressed.pb(upiti[i].x);
        }

        sort(all(compressed));
        compressed.erase(unique(all(compressed)), compressed.end());

        maksVrednost = sz(compressed);

        auto nadji = [&](int x) {
            auto it = lower_bound(all(compressed), x);
            int gde = it - compressed.begin();
            return gde + 1;
        };

        for(int i = 1; i <= n; ++i) {
            v[i].fi = nadji(v[i].fi);
            v[i].se = nadji(v[i].se);
        }

        for(int i = 1; i <= m; ++i) {
            upiti[i].x = nadji(upiti[i].x);
        }
    }();

    for(int i = 1; i <= n; ++i) {
        dbg(v[i]);
    }

    for(int i = 1; i <= m; ++i) {
        dbg(upiti[i].l, upiti[i].r, upiti[i].x);
    }

    auto desnaManjaOd = [&]() {
        vi ans(m + 1);

        vector<Query2> doga[n + 1];

        for(int i = 1; i <= m; ++i) {
            if(upiti[i].l - 1 > 0) {
                doga[upiti[i].l - 1].pb({-1, upiti[i].x, i});
            }

            doga[upiti[i].r].pb({1, upiti[i].x, i});
        }

        ft<int> ft(maksVrednost);

        for(int i = 1; i <= n; ++i) {
            ft.update(v[i].se, 1);

            for(auto z : doga[i]) {
                int ima = ft.query(z.x - 1);
                ans[z.i] += ima * z.znak;
            }
        }

        return ans;
    };

    auto levaVecaOd = [&]() {
        vi ans(m + 1);

        vector<Query2> doga[n + 1];

        for(int i = 1; i <= m; ++i) {
            if(upiti[i].l - 1 > 0) {
                doga[upiti[i].l - 1].pb({-1, upiti[i].x, i});
            }

            doga[upiti[i].r].pb({1, upiti[i].x, i});
        }

        ft<int> ft(maksVrednost);

        for(int i = 1; i <= n; ++i) {
            ft.update(v[i].fi, 1);

            for(auto z : doga[i]) {
                int ima = ft.query(maksVrednost) - ft.query(z.x);
                ans[z.i] += ima * z.znak;
            }
        }

        return ans;
    };

    vi ans = desnaManjaOd();
    // dbg(ans);

    {
        auto temp = levaVecaOd();
        // dbg(temp);

        for(int i = 0; i <= m; ++i) {
            ans[i] += temp[i];
        }
    }

    for(int i = 1; i <= m; ++i) {
        int ima = upiti[i].r - upiti[i].l + 1;
        cout << (ima - ans[i]) << nl;
    }
}
 
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
 
    int testCases = 1;
    // cin >> testCases;
    while(testCases--)
        solve();
}