using System;
using System.Collections.Generic;



class Edge
{
    public int node;
    public int type;
    public Edge(int node, int type)
    {
        this.node = node;
        this.type = type;
    }
}

class Node
{
    public List<Edge> neighbours;
    public bool visited;
    public Node()
    {
        neighbours = new List<Edge>();
        visited = false;
    }
}

class Graph
{
    public List<Node> nodes;
    public Graph(int size)
    {
        nodes = new List<Node>();
        for(int i = 0; i < size; i++)
            nodes.Add(new Node());
    }
    private int dfs(int node, int target, int changes, bool currentState)
    {
        //Console.WriteLine("Node: " + node + " Target: " + target + " Changes: " + changes + " State: " + currentState);
        if (nodes[node].visited) return int.MaxValue;
        if (node == target) return changes;
        nodes[node].visited = true;
        int min = int.MaxValue;
        foreach(Edge e in nodes[node].neighbours)
        {
            min = Math.Min(
                dfs(
                    e.node,
                    target,
                    changes + (
                        ((e.type == 1 && currentState) || (e.type == 0 && !currentState)) ? 0 : 1
                    ),
                    (e.type == 1)
                ),
                min
            );
        }
        nodes[node].visited = false;
        return min;
    }
    public int solve(int start, int end)
    {
        return dfs(start, end, 0, false);
    }
}

class Program
{
    static void Main(string[] args)
    {
        string[] ulazNM = Console.ReadLine().Split(' ');
        int n = Convert.ToInt32(ulazNM[0]);
        int m = Convert.ToInt32(ulazNM[1]);
        Graph g = new Graph(n);
        for(int i = 0; i < m; i++)
        {
            string[] ulaz = Console.ReadLine().Split(' ');
            int a = Convert.ToInt32(ulaz[0])-1;
            int b = Convert.ToInt32(ulaz[1])-1;
            int t = Convert.ToInt32(ulaz[2]);
            g.nodes[a].neighbours.Add(new Edge(b, t));
            g.nodes[b].neighbours.Add(new Edge(a, t));
        }
        string[] ulazSE = Console.ReadLine().Split(' ');
        int s = Convert.ToInt32(ulazSE[0])-1;
        int e = Convert.ToInt32(ulazSE[1])-1;
        Console.WriteLine(g.solve(s, e));
    }
}